/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.rest;

import org.geoserver.catalog.Catalog;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class CacheControllerTest
extends GeoServerSystemTestSupport {
    protected static Catalog catalog;

    protected void onSetUp(SystemTestData testData) throws Exception {
        super.onSetUp(testData);
        catalog = this.getCatalog();
    }

    @Before
    public void login() throws Exception {
        this.login("admin", "geoserver", new String[]{"ROLE_ADMINISTRATOR"});
    }

    @Test
    public void testGetInfo() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/geofence/ruleCache/info");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        CacheControllerTest.assertContentType((String)"text/plain", (MockHttpServletResponse)response);
        String content = response.getContentAsString();
        Assert.assertTrue((String)"Missing RuleStats", (boolean)content.contains("RuleStats["));
        Assert.assertTrue((String)"Missing AdminAuthStats", (boolean)content.contains("AdminAuthStats["));
        Assert.assertTrue((String)"Missing UserStats", (boolean)content.contains("UserStats["));
    }

    @Test
    public void testGetInfoLegacy() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/ruleCache/info");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        CacheControllerTest.assertContentType((String)"text/plain", (MockHttpServletResponse)response);
        String content = response.getContentAsString();
        Assert.assertTrue((String)"Missing RuleStats", (boolean)content.contains("RuleStats["));
        Assert.assertTrue((String)"Missing AdminAuthStats", (boolean)content.contains("AdminAuthStats["));
        Assert.assertTrue((String)"Missing UserStats", (boolean)content.contains("UserStats["));
    }

    @Test
    public void testInvalidate() throws Exception {
        MockHttpServletResponse response = this.putAsServletResponse("/rest/geofence/ruleCache/invalidate");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        CacheControllerTest.assertContentType((String)"text/plain", (MockHttpServletResponse)response);
        String content = response.getContentAsString();
        Assert.assertEquals((Object)"OK", (Object)content);
    }
}

