/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.containers;

import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.geofence.config.GeoFenceConfiguration;
import org.geoserver.geofence.containers.ContainerAccessResolver;
import org.geoserver.geofence.containers.ContainerLimitResolver;
import org.geoserver.geofence.services.RuleReaderService;
import org.geoserver.geofence.util.GeomHelper;
import org.geoserver.security.impl.LayerGroupContainmentCache;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.springframework.security.core.Authentication;

public class DefaultContainerAccessResolver
implements ContainerAccessResolver {
    static final Logger LOGGER = Logging.getLogger(DefaultContainerAccessResolver.class);
    private RuleReaderService ruleReaderService;

    public DefaultContainerAccessResolver() {
    }

    public DefaultContainerAccessResolver(RuleReaderService rulesService) {
        this.ruleReaderService = rulesService;
    }

    public void setRuleReaderService(RuleReaderService ruleReaderService) {
        this.ruleReaderService = ruleReaderService;
    }

    @Override
    public ContainerLimitResolver.ProcessingResult getContainerResolverResult(CatalogInfo resourceInfo, String layer, String workspace, GeoFenceConfiguration configuration, String callerIp, Authentication user, List<LayerGroupInfo> containers, Collection<LayerGroupContainmentCache.LayerGroupSummary> summaries) {
        ContainerLimitResolver resolver = summaries != null ? new ContainerLimitResolver(summaries, this.ruleReaderService, user, layer, workspace, callerIp, configuration) : new ContainerLimitResolver(containers, this.ruleReaderService, user, layer, workspace, callerIp, configuration);
        ContainerLimitResolver.ProcessingResult result = resolver.resolveResourceInGroupLimits();
        Geometry intersect = result.getIntersectArea();
        Geometry clip = result.getClipArea();
        CoordinateReferenceSystem crs = GeomHelper.getCRSFromInfo(resourceInfo);
        if (intersect != null) {
            intersect = GeomHelper.reprojectGeometry(intersect, crs);
            result.setIntersectArea(intersect);
        }
        if (clip != null) {
            clip = GeomHelper.reprojectGeometry(clip, crs);
            result.setClipArea(clip);
        }
        return result;
    }
}

