/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.rest;

import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.catalog.Catalog;
import org.geoserver.geofence.cache.CacheManager;
import org.geoserver.rest.catalog.AbstractCatalogController;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ControllerAdvice
@RequestMapping(path={"/rest/geofence/ruleCache", "/rest/ruleCache", "/rest/geofence/cache"})
public class CacheController
extends AbstractCatalogController {
    static final Logger LOGGER = Logging.getLogger(CacheController.class);
    @Autowired
    private CacheManager cacheManager;

    public CacheController(Catalog catalog) {
        super(catalog);
    }

    @GetMapping(path={"/info"}, produces={"text/plain"})
    public String getCacheInfo() {
        StringBuilder sb = new StringBuilder();
        this.appendStats(sb, "RuleStats", this.cacheManager.getRuleCache());
        this.appendStats(sb, "AdminAuthStats", this.cacheManager.getAuthCache());
        this.appendStats(sb, "UserStats", this.cacheManager.getUserCache());
        this.appendStats(sb, "ContStats", this.cacheManager.getContainerCache());
        return sb.toString();
    }

    private void appendStats(StringBuilder sb, String label, LoadingCache cache) {
        CacheStats stats = cache.stats();
        sb.append(label).append("[ size:").append(cache.size()).append("/").append(this.cacheManager.getCacheInitParams().getSize()).append(" hitCount:").append(stats.hitCount()).append(" missCount:").append(stats.missCount()).append(" loadSuccessCount:").append(stats.loadSuccessCount()).append(" loadExceptionCount:").append(stats.loadExceptionCount()).append(" totalLoadTime:").append(stats.totalLoadTime()).append(" evictionCount:").append(stats.evictionCount()).append("] \n");
    }

    @PutMapping(produces={"text/plain"})
    @RequestMapping(path={"/invalidate"})
    public String invalidateCache() {
        LOGGER.log(Level.WARNING, "INVALIDATING CACHE");
        this.cacheManager.invalidateAll();
        return "OK";
    }
}

