/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geofence.wpscommon;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

public class ChainStatusHolder {
    private static final Logger LOGGER = Logging.getLogger(ChainStatusHolder.class);
    private Map<String, LinkedList<String>> chains = new HashMap<String, LinkedList<String>>();

    public void stackProcess(String execId, String procName) {
        LinkedList<String> chain = this.chains.getOrDefault(execId, null);
        if (chain == null) {
            LOGGER.fine("Creating chain for " + execId);
            chain = new LinkedList<String>();
            this.chains.put(execId, chain);
        }
        chain.add(procName);
    }

    public boolean unstackProcess(String execId, String procName) {
        LinkedList chain = this.chains.getOrDefault(execId, null);
        if (chain == null) {
            LOGGER.severe("No chain for execution ID " + execId);
            return false;
        }
        String last = (String)chain.pollLast();
        if (!procName.equals(last)) {
            LOGGER.severe("Returning from [" + procName + "], but last called process was [" + last + "] for execution ID " + execId);
            return false;
        }
        if (chain.isEmpty()) {
            LOGGER.fine("Removing chain for " + execId);
            this.chains.remove(execId);
        }
        return true;
    }

    public String stackToString(String execId) {
        LinkedList chain = this.chains.getOrDefault(execId, null);
        if (chain == null) {
            return "[MISSING CHAIN]";
        }
        return String.join((CharSequence)"/", chain);
    }

    public List<String> getCurrentStack(String execId) {
        LinkedList chain = this.chains.getOrDefault(execId, null);
        return chain == null ? null : Collections.unmodifiableList(chain);
    }
}

