/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geoserver.authentication.auth;

import java.util.logging.Logger;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.geofence.services.RuleReaderService;
import org.geoserver.geoserver.authentication.auth.GeoFenceAuthenticationProvider;
import org.geoserver.geoserver.authentication.auth.GeoFenceAuthenticationProviderConfig;
import org.geoserver.security.GeoServerAuthenticationProvider;
import org.geoserver.security.GeoServerSecurityManager;
import org.geoserver.security.GeoServerSecurityProvider;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geotools.util.logging.Logging;
import org.springframework.beans.factory.InitializingBean;

public class GeoFenceSecurityProvider
extends GeoServerSecurityProvider
implements InitializingBean {
    private static final Logger LOGGER = Logging.getLogger((String)GeoFenceSecurityProvider.class.getName());
    private RuleReaderService ruleReaderService;
    private GeoServerSecurityManager securityManager;

    public Class<? extends GeoServerAuthenticationProvider> getAuthenticationProviderClass() {
        return GeoFenceAuthenticationProvider.class;
    }

    public GeoFenceAuthenticationProvider createAuthenticationProvider(SecurityNamedServiceConfig config) {
        GeoFenceAuthenticationProvider authProv = new GeoFenceAuthenticationProvider();
        authProv.setRuleReaderService(this.ruleReaderService);
        return authProv;
    }

    public void setRuleReaderService(RuleReaderService ruleReaderService) {
        this.ruleReaderService = ruleReaderService;
    }

    public void setSecurityManager(GeoServerSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public void configure(XStreamPersister xp) {
        super.configure(xp);
        xp.getXStream().alias("geofence", GeoFenceAuthenticationProviderConfig.class);
    }

    public void afterPropertiesSet() throws Exception {
        this.ensureProviderConfigFile();
    }

    private void ensureProviderConfigFile() {
        if (this.securityManager == null) {
            LOGGER.severe("securityManager is null!");
            return;
        }
        try {
            SecurityAuthProviderConfig loadedConfig = this.securityManager.loadAuthenticationProviderConfig("geofence");
            if (loadedConfig == null) {
                LOGGER.warning("Configuration file not found, creating default config");
                GeoFenceAuthenticationProviderConfig defaultConfig = new GeoFenceAuthenticationProviderConfig();
                defaultConfig.setName("geofence");
                defaultConfig.setClassName(GeoFenceAuthenticationProvider.class.getName());
                this.securityManager.saveAuthenticationProvider((SecurityAuthProviderConfig)defaultConfig);
            }
        }
        catch (Exception ex) {
            LOGGER.severe("Error in configuration: " + ex.getMessage());
        }
    }
}

