/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.geoserver.authentication.filter;

import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.geoserver.geoserver.authentication.auth.GeoFenceAuthenticationProvider;
import org.geoserver.geoserver.authentication.auth.GeoFenceSecurityProvider;
import org.geoserver.security.config.SecurityAuthProviderConfig;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.filter.GeoServerAuthenticationFilter;
import org.geoserver.security.filter.GeoServerCompositeFilter;
import org.geotools.util.logging.Logging;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

public class GeoFenceAuthFilter
extends GeoServerCompositeFilter
implements GeoServerAuthenticationFilter {
    static final Logger LOGGER = Logging.getLogger(GeoFenceAuthFilter.class);
    private GeoFenceSecurityProvider geofenceAuth;
    static final String USER_ROLE = "ROLE_USER";
    private BasicAuthenticationEntryPoint aep;

    public void initializeFromConfig(SecurityNamedServiceConfig config) throws IOException {
        super.initializeFromConfig(config);
        this.aep = new BasicAuthenticationEntryPoint();
        this.aep.setRealmName("GeoServer Realm");
        try {
            this.aep.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        SecurityAuthProviderConfig authCfg = this.securityManager.loadAuthenticationProviderConfig("geofence");
        GeoFenceAuthenticationProvider geofenceAuthProvider = this.geofenceAuth.createAuthenticationProvider((SecurityNamedServiceConfig)authCfg);
        BasicAuthenticationFilter filter = new BasicAuthenticationFilter((AuthenticationManager)geofenceAuthProvider, (AuthenticationEntryPoint)this.aep);
        filter.afterPropertiesSet();
        this.getNestedFilters().add(filter);
    }

    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.aep;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        request.setAttribute("_AUTHENTICATION_ENTRY_POINT_HEADER", (Object)this.aep);
        super.doFilter(request, response, chain);
    }

    public boolean applicableForHtml() {
        return true;
    }

    public boolean applicableForServices() {
        return true;
    }

    public void setGeofenceAuth(GeoFenceSecurityProvider geofenceAuth) {
        this.geofenceAuth = geofenceAuth;
    }

    class BasicUser {
        String name;
        String pw;

        public BasicUser(String name, String pw) {
            this.name = name;
            this.pw = pw;
        }
    }
}

