/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.inspire.UniqueResourceIdentifier;
import org.geoserver.inspire.UniqueResourceIdentifiers;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class InspireConverterFactory
implements ConverterFactory {
    static final Logger LOGGER = Logging.getLogger(InspireConverterFactory.class);

    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (String.class.isAssignableFrom(source) && UniqueResourceIdentifiers.class.isAssignableFrom(target)) {
            return new SpatialDatasetIdentifiersConverter();
        }
        if (String.class.isAssignableFrom(target) && UniqueResourceIdentifiers.class.isAssignableFrom(source)) {
            return new SpatialDatasetIdentifiersConverter();
        }
        return null;
    }

    public class SpatialDatasetIdentifiersConverter
    implements Converter {
        public <T> T convert(Object source, Class<T> target) throws Exception {
            if (source instanceof String && UniqueResourceIdentifiers.class.equals(target)) {
                String[] values;
                UniqueResourceIdentifiers identifiers = new UniqueResourceIdentifiers();
                for (String value : values = ((String)source).split("\\s*;\\s*")) {
                    String[] elements = value.split("\\s*,\\s*");
                    if (elements.length == 0) continue;
                    String code = elements[0];
                    if ("".equals(code)) {
                        LOGGER.warning("Skipping InspireDatasetIdentifier because code is empty: " + value);
                        continue;
                    }
                    String namespace = null;
                    if (elements.length > 1) {
                        namespace = elements[1];
                        try {
                            new URI(namespace);
                        }
                        catch (URISyntaxException e) {
                            LOGGER.log(Level.WARNING, "Skipping InspireDatasetIdentifier because namespace is not a valid URI: " + value, e);
                            continue;
                        }
                        if (namespace.trim().equals("")) {
                            namespace = null;
                        }
                    }
                    String metadataURL = null;
                    if (elements.length > 2) {
                        metadataURL = elements[2];
                        try {
                            new URI(metadataURL);
                        }
                        catch (URISyntaxException e) {
                            LOGGER.log(Level.WARNING, "Skipping InspireDatasetIdentifier because metadataURL is not a valid URI: " + value, e);
                            continue;
                        }
                    }
                    UniqueResourceIdentifier id = new UniqueResourceIdentifier(code, namespace, metadataURL);
                    identifiers.add(id);
                }
                return target.cast(identifiers);
            }
            if (source instanceof UniqueResourceIdentifiers && String.class.equals(target)) {
                UniqueResourceIdentifiers ids = (UniqueResourceIdentifiers)source;
                if (!ids.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (UniqueResourceIdentifier id : ids) {
                        String ns = id.getNamespace();
                        String metadata = id.getMetadataURL();
                        String code = id.getCode();
                        sb.append(code).append(",");
                        if (ns != null) {
                            sb.append(ns);
                        }
                        sb.append(",");
                        if (metadata != null) {
                            sb.append(metadata);
                        }
                        sb.append(";");
                    }
                    sb.setLength(sb.length() - 1);
                    return target.cast(sb.toString());
                }
                return target.cast("");
            }
            return null;
        }
    }
}

