/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire.web;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Session;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.FormComponentFeedbackBorder;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.ReuseIfModelsEqualStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.inspire.UniqueResourceIdentifier;
import org.geoserver.inspire.UniqueResourceIdentifiers;
import org.geoserver.inspire.web.UniqueResourceIdentifiersProvider;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.URIValidator;

public class UniqueResourceIdentifiersEditor
extends FormComponentPanel<UniqueResourceIdentifiers> {
    private GeoServerTablePanel<UniqueResourceIdentifier> identifiers;
    private AjaxButton button;

    public UniqueResourceIdentifiersEditor(String id, IModel<UniqueResourceIdentifiers> identifiersModel) {
        super(id, identifiersModel);
        if (identifiersModel.getObject() == null) {
            identifiersModel.setObject((Object)new UniqueResourceIdentifiers());
        }
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        final UniqueResourceIdentifiersProvider provider = new UniqueResourceIdentifiersProvider((UniqueResourceIdentifiers)identifiersModel.getObject());
        this.identifiers = new GeoServerTablePanel<UniqueResourceIdentifier>("identifiers", (GeoServerDataProvider)provider, false){

            protected Component getComponentForProperty(String id, final IModel<UniqueResourceIdentifier> itemModel, GeoServerDataProvider.Property<UniqueResourceIdentifier> property) {
                String name = property.getName();
                if ("code".equals(name)) {
                    Fragment codeFragment = new Fragment(id, "txtFragment", (MarkupContainer)UniqueResourceIdentifiersEditor.this);
                    FormComponentFeedbackBorder codeBorder = new FormComponentFeedbackBorder("border");
                    codeFragment.add(new Component[]{codeBorder});
                    TextField code = new TextField("txt", (IModel)new PropertyModel(itemModel, "code"));
                    code.setLabel((IModel)new ParamResourceModel("th.code", (Component)UniqueResourceIdentifiersEditor.this, new Object[0]));
                    code.setRequired(true);
                    codeBorder.add(new Component[]{code});
                    return codeFragment;
                }
                if ("namespace".equals(name)) {
                    Fragment nsFragment = new Fragment(id, "txtFragment", (MarkupContainer)UniqueResourceIdentifiersEditor.this);
                    FormComponentFeedbackBorder namespaceBorder = new FormComponentFeedbackBorder("border");
                    nsFragment.add(new Component[]{namespaceBorder});
                    TextField namespace = new TextField("txt", (IModel)new PropertyModel(itemModel, "namespace"));
                    namespace.setLabel((IModel)new ParamResourceModel("th.namespace", (Component)UniqueResourceIdentifiersEditor.this, new Object[0]));
                    namespace.add((IValidator)new URIValidator());
                    namespaceBorder.add(new Component[]{namespace});
                    return nsFragment;
                }
                if ("metadataURL".equals(name)) {
                    Fragment urlFragment = new Fragment(id, "txtFragment", (MarkupContainer)UniqueResourceIdentifiersEditor.this);
                    FormComponentFeedbackBorder namespaceBorder = new FormComponentFeedbackBorder("border");
                    urlFragment.add(new Component[]{namespaceBorder});
                    TextField url = new TextField("txt", (IModel)new PropertyModel(itemModel, "metadataURL"));
                    url.add((IValidator)new URIValidator());
                    namespaceBorder.add(new Component[]{url});
                    return urlFragment;
                }
                if ("remove".equals(name)) {
                    Fragment removeFragment = new Fragment(id, "removeFragment", (MarkupContainer)UniqueResourceIdentifiersEditor.this);
                    GeoServerAjaxFormLink removeLink = new GeoServerAjaxFormLink("remove"){

                        protected void onClick(AjaxRequestTarget target, Form form) {
                            UniqueResourceIdentifiers identifiers = provider.getItems();
                            UniqueResourceIdentifier sdi = (UniqueResourceIdentifier)itemModel.getObject();
                            identifiers.remove(sdi);
                            target.add(new Component[]{container});
                        }
                    };
                    removeFragment.add(new Component[]{removeLink});
                    return removeFragment;
                }
                return null;
            }
        };
        this.identifiers.setItemReuseStrategy(ReuseIfModelsEqualStrategy.getInstance());
        this.identifiers.setPageable(false);
        this.identifiers.setSortable(false);
        this.identifiers.setFilterable(false);
        container.add(new Component[]{this.identifiers});
        this.button = new AjaxButton("addIdentifier"){

            protected void onSubmit(AjaxRequestTarget target) {
                UniqueResourceIdentifiersProvider provider = (UniqueResourceIdentifiersProvider)UniqueResourceIdentifiersEditor.this.identifiers.getDataProvider();
                provider.getItems().add(new UniqueResourceIdentifier());
                target.add(new Component[]{container});
            }

            protected void onError(AjaxRequestTarget target) {
                Session.get().getFeedbackMessages().clear();
                Session.get().dirty();
                this.onSubmit(target);
            }
        };
        this.add(new Component[]{this.button});
        this.add((IValidator & Serializable)validatable -> {
            UniqueResourceIdentifiers identifiers = provider.getItems();
            if (identifiers.isEmpty()) {
                ValidationError error = new ValidationError();
                String message = new ParamResourceModel("noSpatialDatasetIdentifiers", (Component)this, new Object[0]).getString();
                error.setMessage(message);
                validatable.error((IValidationError)error);
            }
        });
    }

    public void convertInput() {
        UniqueResourceIdentifiersProvider provider = (UniqueResourceIdentifiersProvider)this.identifiers.getDataProvider();
        this.setConvertedInput(provider.getItems());
    }
}

