/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.ListMultipleChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.ValidationErrorFeedback;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.ServiceInfo;
import org.geoserver.inspire.InspireMetadata;
import org.geoserver.inspire.InspireTestSupport;
import org.geoserver.inspire.UniqueResourceIdentifier;
import org.geoserver.inspire.UniqueResourceIdentifiers;
import org.geoserver.inspire.web.InspireAdminPanel;
import org.geoserver.inspire.web.LanguageDropDownChoice;
import org.geoserver.inspire.web.UniqueResourceIdentifiersEditor;
import org.geoserver.wcs.WCSInfo;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wms.WMSInfo;
import org.geotools.util.Converters;
import org.junit.Assert;
import org.junit.Test;

public class InspirePanelTest
extends GeoServerWicketTestSupport
implements Serializable {
    private void startPage(ServiceInfo serviceInfo) {
        tester.startPage((Page)new FormTestPage((ComponentBuilder & Serializable)id -> new InspireAdminPanel(id, (IModel)new Model((Serializable)serviceInfo))));
    }

    @Test
    public void testNoInspireSettingsWMS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:createExtendedCapabilities", CheckBox.class);
        tester.assertModelValue("form:panel:createExtendedCapabilities", (Object)false);
        try {
            tester.assertComponent("form:panel:container:configs:language", LanguageDropDownChoice.class);
            Assert.fail((String)"Shouldn't have found section for INSPIRE extension configuration");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Test
    public void testCreateExtCapsOffWMS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(false));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:createExtendedCapabilities", CheckBox.class);
        tester.assertModelValue("form:panel:createExtendedCapabilities", (Object)false);
        tester.assertInvisible("form:panel:container:configs");
    }

    @Test
    public void testCreateExtCapsOffWFS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(false));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:createExtendedCapabilities", CheckBox.class);
        tester.assertModelValue("form:panel:createExtendedCapabilities", (Object)false);
        tester.assertInvisible("form:panel:container:configs");
    }

    @Test
    public void testCreateExtCapsOffWCS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WCSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(false));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:createExtendedCapabilities", CheckBox.class);
        tester.assertModelValue("form:panel:createExtendedCapabilities", (Object)false);
        tester.assertInvisible("form:panel:container:configs");
    }

    @Test
    public void testWithFullSettingsWMS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:createExtendedCapabilities", CheckBox.class);
        tester.assertModelValue("form:panel:createExtendedCapabilities", (Object)true);
        tester.assertComponent("form:panel:container:configs:language", LanguageDropDownChoice.class);
        tester.assertModelValue("form:panel:container:configs:language", (Object)"fre");
        this.print((Component)tester.getLastRenderedPage(), true, true);
        tester.assertComponent("form:panel:container:configs:border:border_body:metadataURL", TextField.class);
        tester.assertModelValue("form:panel:container:configs:border:border_body:metadataURL", (Object)"http://foo.com?bar=baz");
        tester.assertComponent("form:panel:container:configs:metadataURLType", DropDownChoice.class);
        tester.assertModelValue("form:panel:container:configs:metadataURLType", (Object)"application/vnd.iso.19139+xml");
        try {
            tester.assertComponent("form:panel:container:configs:datasetIdentifiersContainer:spatialDatasetIdentifiers", UniqueResourceIdentifiersEditor.class);
            Assert.fail((String)"Shouldn't have found a Spatial Dataset Identifers section");
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
    }

    @Test
    public void testWithFullSettingsWFS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:createExtendedCapabilities", CheckBox.class);
        tester.assertModelValue("form:panel:createExtendedCapabilities", (Object)true);
        tester.assertComponent("form:panel:container:configs:language", LanguageDropDownChoice.class);
        tester.assertModelValue("form:panel:container:configs:language", (Object)"fre");
        tester.assertComponent("form:panel:container:configs:border:border_body:metadataURL", TextField.class);
        tester.assertModelValue("form:panel:container:configs:border:border_body:metadataURL", (Object)"http://foo.com?bar=baz");
        tester.assertComponent("form:panel:container:configs:metadataURLType", DropDownChoice.class);
        tester.assertModelValue("form:panel:container:configs:metadataURLType", (Object)"application/vnd.iso.19139+xml");
        tester.assertComponent("form:panel:container:configs:datasetIdentifiersContainer:spatialDatasetIdentifiers", UniqueResourceIdentifiersEditor.class);
        UniqueResourceIdentifiers expected = (UniqueResourceIdentifiers)Converters.convert((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two", UniqueResourceIdentifiers.class);
        tester.assertModelValue("form:panel:container:configs:datasetIdentifiersContainer:spatialDatasetIdentifiers", (Object)expected);
    }

    @Test
    public void testWithFullSettingsWCS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WCSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:createExtendedCapabilities", CheckBox.class);
        tester.assertModelValue("form:panel:createExtendedCapabilities", (Object)true);
        tester.assertComponent("form:panel:container:configs:language", LanguageDropDownChoice.class);
        tester.assertModelValue("form:panel:container:configs:language", (Object)"fre");
        tester.assertComponent("form:panel:container:configs:border:border_body:metadataURL", TextField.class);
        tester.assertModelValue("form:panel:container:configs:border:border_body:metadataURL", (Object)"http://foo.com?bar=baz");
        tester.assertComponent("form:panel:container:configs:metadataURLType", DropDownChoice.class);
        tester.assertModelValue("form:panel:container:configs:metadataURLType", (Object)"application/vnd.iso.19139+xml");
        tester.assertComponent("form:panel:container:configs:datasetIdentifiersContainer:spatialDatasetIdentifiers", UniqueResourceIdentifiersEditor.class);
        UniqueResourceIdentifiers expected = (UniqueResourceIdentifiers)Converters.convert((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two", UniqueResourceIdentifiers.class);
        tester.assertModelValue("form:panel:container:configs:datasetIdentifiersContainer:spatialDatasetIdentifiers", (Object)expected);
    }

    @Test
    public void testNoLanguageWMS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form:panel:container:configs:language", LanguageDropDownChoice.class);
        tester.assertModelValue("form:panel:container:configs:language", (Object)"eng");
    }

    @Test
    public void testNoMediaTypeWMS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form:panel:container:configs:metadataURLType", DropDownChoice.class);
        tester.assertModelValue("form:panel:container:configs:metadataURLType", null);
    }

    @Test
    public void testCreateExtCapMissingWithRequiredSettingsWMS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:createExtendedCapabilities", CheckBox.class);
        tester.assertModelValue("form:panel:createExtendedCapabilities", (Object)true);
        tester.assertComponent("form:panel:container:configs:language", LanguageDropDownChoice.class);
        tester.assertModelValue("form:panel:container:configs:language", (Object)"fre");
    }

    @Test
    public void testCreateExtCapMissingWithoutRequiredSettingsWMS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:createExtendedCapabilities", CheckBox.class);
        tester.assertModelValue("form:panel:createExtendedCapabilities", (Object)false);
        tester.assertInvisible("form:panel:container:configs");
    }

    @Test
    public void testCreateExtCapMissingWithRequiredSettingsWFS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:createExtendedCapabilities", CheckBox.class);
        tester.assertModelValue("form:panel:createExtendedCapabilities", (Object)true);
        tester.assertComponent("form:panel:container:configs:language", LanguageDropDownChoice.class);
        tester.assertModelValue("form:panel:container:configs:language", (Object)"fre");
    }

    @Test
    public void testCreateExtCapMissingWithoutRequiredSettingsWFS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:createExtendedCapabilities", CheckBox.class);
        tester.assertModelValue("form:panel:createExtendedCapabilities", (Object)false);
        tester.assertInvisible("form:panel:container:configs");
    }

    @Test
    public void testCreateExtCapMissingWithRequiredSettingsWCS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WCSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:createExtendedCapabilities", CheckBox.class);
        tester.assertModelValue("form:panel:createExtendedCapabilities", (Object)true);
        tester.assertComponent("form:panel:container:configs:language", LanguageDropDownChoice.class);
        tester.assertModelValue("form:panel:container:configs:language", (Object)"fre");
    }

    @Test
    public void testCreateExtCapMissingWithoutRequiredSettingsWCS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WCSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form", Form.class);
        tester.assertComponent("form:panel:createExtendedCapabilities", CheckBox.class);
        tester.assertModelValue("form:panel:createExtendedCapabilities", (Object)false);
        tester.assertInvisible("form:panel:container:configs");
    }

    @Test
    public void testEditBasicWFS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        FormTester ft = tester.newFormTester("form");
        ft.select("panel:container:configs:language", 0);
        ft.setValue("panel:container:configs:border:border_body:metadataURL", "http://www.geoserver.org/test");
        ft.select("panel:container:configs:metadataURLType", 0);
        ft.submit();
        tester.assertModelValue("form:panel:container:configs:language", (Object)"bul");
        tester.assertModelValue("form:panel:container:configs:border:border_body:metadataURL", (Object)"http://www.geoserver.org/test");
        tester.assertModelValue("form:panel:container:configs:metadataURLType", (Object)"application/vnd.ogc.csw.GetRecordByIdResponse_xml");
    }

    @Test
    public void testEditBasicWCS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WCSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        FormTester ft = tester.newFormTester("form");
        ft.select("panel:container:configs:language", 0);
        ft.setValue("panel:container:configs:border:border_body:metadataURL", "http://www.geoserver.org/test");
        ft.select("panel:container:configs:metadataURLType", 0);
        ft.submit();
        tester.assertModelValue("form:panel:container:configs:language", (Object)"bul");
        tester.assertModelValue("form:panel:container:configs:border:border_body:metadataURL", (Object)"http://www.geoserver.org/test");
        tester.assertModelValue("form:panel:container:configs:metadataURLType", (Object)"application/vnd.ogc.csw.GetRecordByIdResponse_xml");
    }

    @Test
    public void testSubmitWithoutRequiredWMS() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        FormTester ft = tester.newFormTester("form");
        ft.setValue("panel:createExtendedCapabilities", true);
        tester.executeAjaxEvent("form:panel:createExtendedCapabilities", "change");
        tester.submitForm("form");
        List messages = tester.getMessages(400);
        Assert.assertEquals((long)1L, (long)messages.size());
        String message = (String)((Object)((ValidationErrorFeedback)messages.get(0)).getMessage());
        Assert.assertTrue((boolean)message.contains("Service Metadata URL"));
    }

    @Test
    public void testSerializedModel() {
        UniqueResourceIdentifier identifier = new UniqueResourceIdentifier("one", "http://www.geoserver.org/one");
        UniqueResourceIdentifiers identifiers = new UniqueResourceIdentifiers();
        identifiers.add((Object)identifier);
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        InspireTestSupport.clearInspireMetadata(serviceInfo.getMetadata());
        serviceInfo.getMetadata().put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        serviceInfo.getMetadata().put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        serviceInfo.getMetadata().put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        serviceInfo.getMetadata().put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)identifiers);
        this.getGeoServer().save(serviceInfo);
        final ServiceModel model = new ServiceModel(WFSInfo.class);
        tester.startPage((Page)new FormTestPage(new ComponentBuilder(){
            private static final long serialVersionUID = -5996984687607456244L;

            public Component buildComponent(String id) {
                InspireAdminPanel adminPanel2;
                byte[] serialized;
                InspireAdminPanel adminPanel = new InspireAdminPanel(id, (IModel)model);
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    try (ObjectOutputStream oos = new ObjectOutputStream(os);){
                        oos.writeObject(adminPanel);
                    }
                    serialized = os.toByteArray();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try (ByteArrayInputStream is = new ByteArrayInputStream(serialized);
                     ObjectInputStream ois = new ObjectInputStream(is);){
                    adminPanel2 = (InspireAdminPanel)ois.readObject();
                }
                catch (IOException | ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                return adminPanel2;
            }
        }));
        FormTester formTester = tester.newFormTester("form");
        formTester.setValue("panel:container:configs:datasetIdentifiersContainer:spatialDatasetIdentifiers:container:identifiers:listContainer:items:1:itemProperties:0:component:border:border_body:txt", "two");
        formTester.submit();
        ServiceModel pageModel = (ServiceModel)tester.getComponentFromLastRenderedPage("form:panel").getDefaultModel();
        identifier = new UniqueResourceIdentifier("two", "http://www.geoserver.org/one");
        identifiers = new UniqueResourceIdentifiers();
        identifiers.add((Object)identifier);
        Assert.assertEquals((Object)identifiers, (Object)((ServiceInfo)pageModel.getObject()).getMetadata().get((Object)InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key));
    }

    @Test
    public void testLanguageEditor() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WFSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form", Form.class);
        FormTester form = tester.newFormTester("form");
        tester.assertComponent("form:panel:createExtendedCapabilities", CheckBox.class);
        tester.assertModelValue("form:panel:createExtendedCapabilities", (Object)true);
        tester.assertComponent("form:panel:container:configs:language", LanguageDropDownChoice.class);
        tester.assertModelValue("form:panel:container:configs:language", (Object)"fre");
        form.setValue("panel:container:configs:border:border_body:metadataURL", "http://www.geoserver.org/test");
        form.select("panel:container:configs:metadataURLType", 0);
        form.setValue("panel:container:configs:datasetIdentifiersContainer:spatialDatasetIdentifiers:container:identifiers:listContainer:items:1:itemProperties:1:component:border:border_body:txt", "http://www.geoserver.org/meta");
        form.setValue("panel:container:configs:datasetIdentifiersContainer:spatialDatasetIdentifiers:container:identifiers:listContainer:items:1:itemProperties:0:component:border:border_body:txt", "code");
        tester.assertComponent("form:panel:container:configs:otherLanguages:languages", ListMultipleChoice.class);
        tester.assertComponent("form:panel:container:configs:otherLanguages:selectLanguage", LanguageDropDownChoice.class);
        form = tester.newFormTester("form");
        form.select("panel:container:configs:otherLanguages:selectLanguage", 1);
        tester.executeAjaxEvent("form:panel:container:configs:otherLanguages:addLanguage", "click");
        form = tester.newFormTester("form");
        form.submit();
        tester.assertNoErrorMessage();
    }

    @Test
    public void testLanguageEditorRemove() {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.OTHER_LANGUAGES.key, (Serializable)((Object)"ita,eng"));
        metadata.put(InspireMetadata.SPATIAL_DATASET_IDENTIFIER_TYPE.key, (Serializable)((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two"));
        this.getGeoServer().save(serviceInfo);
        this.startPage(serviceInfo);
        tester.assertComponent("form", Form.class);
        FormTester form = tester.newFormTester("form");
        tester.assertComponent("form:panel:createExtendedCapabilities", CheckBox.class);
        tester.assertModelValue("form:panel:createExtendedCapabilities", (Object)true);
        tester.assertComponent("form:panel:container:configs:language", LanguageDropDownChoice.class);
        tester.assertModelValue("form:panel:container:configs:language", (Object)"fre");
        tester.assertComponent("form:panel:container:configs:otherLanguages:languages", ListMultipleChoice.class);
        tester.assertComponent("form:panel:container:configs:otherLanguages:selectLanguage", LanguageDropDownChoice.class);
        ListMultipleChoice choices = (ListMultipleChoice)tester.getComponentFromLastRenderedPage("form:panel:container:configs:otherLanguages:languages");
        Assert.assertTrue((choices.getChoices().contains("ita") && choices.getChoices().contains("eng") ? 1 : 0) != 0);
        form.selectMultiple("panel:container:configs:otherLanguages:languages", new int[]{0, 1});
        tester.executeAjaxEvent("form:panel:container:configs:otherLanguages:removeLanguages", "click");
        ListMultipleChoice choices2 = (ListMultipleChoice)tester.getComponentFromLastRenderedPage("form:panel:container:configs:otherLanguages:languages");
        Assert.assertFalse((choices2.getChoices().contains("ita") || choices2.getChoices().contains("eng") ? 1 : 0) != 0);
    }

    private class ServiceModel
    extends LoadableDetachableModel<ServiceInfo> {
        private static final long serialVersionUID = 7281859913779496011L;
        Class<? extends ServiceInfo> serviceClass;
        ServiceInfo service;

        ServiceModel(Class<? extends ServiceInfo> serviceClass) {
            this.serviceClass = serviceClass;
        }

        protected ServiceInfo load() {
            if (this.serviceClass != null) {
                return InspirePanelTest.this.getGeoServer().getService(this.serviceClass);
            }
            return this.service;
        }

        public void detach() {
            this.service = null;
        }
    }
}

