/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire.wms;

import java.io.Serializable;
import java.util.Locale;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.ServiceInfo;
import org.geoserver.inspire.InspireMetadata;
import org.geoserver.inspire.InspireTestSupport;
import org.geoserver.inspire.ServicesTestSupport;
import org.geoserver.wms.WMSInfo;
import org.geotools.api.util.InternationalString;
import org.geotools.util.GrowableInternationalString;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WMSExtendedCapabilitiesTest
extends ServicesTestSupport {
    private static final String WMS_1_1_1_GETCAPREQUEST = "wms?request=GetCapabilities&service=WMS&version=1.1.1";
    private static final String WMS_1_3_0_GETCAPREQUEST = "wms?request=GetCapabilities&service=WMS&version=1.3.0";

    @Override
    protected String getGetCapabilitiesRequestPath() {
        return WMS_1_3_0_GETCAPREQUEST;
    }

    @Override
    protected String getMetadataUrl() {
        return "http://foo.com?bar=baz";
    }

    @Override
    protected String getMetadataType() {
        return "application/vnd.iso.19139+xml";
    }

    @Override
    protected String getLanguage() {
        return "fre";
    }

    @Override
    protected String getAlternateMetadataType() {
        return "application/vnd.ogc.csw.GetRecordByIdResponse_xml";
    }

    @Override
    protected ServiceInfo getServiceInfo() {
        return this.getGeoServer().getService(WMSInfo.class);
    }

    @Override
    protected String getInspireNameSpace() {
        return "http://inspire.ec.europa.eu/schemas/inspire_vs/1.0";
    }

    @Override
    protected String getInspireSchema() {
        return "https://inspire.ec.europa.eu/schemas/inspire_vs/1.0/inspire_vs.xsd";
    }

    @Test
    public void testExtCaps111WithFullSettings() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WMS_1_1_1_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_vs/1.0", "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)0L, (long)nodeList.getLength());
    }

    @Test
    public void testINSPIRESchemaLocations() throws Exception {
        Document dom = this.getAsDOM(WMS_1_3_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_vs/1.0", "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)0L, (long)nodeList.getLength());
        String schemaLocation = dom.getDocumentElement().getAttribute("xsi:schemaLocation");
        InspireTestSupport.assertSchemaLocationContains(schemaLocation, "http://inspire.ec.europa.eu/schemas/inspire_vs/1.0", "https://inspire.ec.europa.eu/schemas/inspire_vs/1.0/inspire_vs.xsd");
    }

    @Test
    public void testSupportedLanguages() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.OTHER_LANGUAGES.key, (Serializable)((Object)"ita,eng"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WMS_1_3_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_vs/1.0", "ExtendedCapabilities");
        Element extendedCaps = (Element)nodeList.item(0);
        Element suppLangs = (Element)extendedCaps.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "SupportedLanguages").item(0);
        nodeList = suppLangs.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "DefaultLanguage");
        Assert.assertEquals((String)"Number of DefaultLanguage elements", (long)1L, (long)nodeList.getLength());
        nodeList = suppLangs.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "SupportedLanguage");
        Assert.assertEquals((String)"Number of Supported Languages", (long)2L, (long)nodeList.getLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResponseLanguageMatchesRequested() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        try {
            ServiceInfo wmsInfo = this.getGeoServer().getService(WMSInfo.class);
            GrowableInternationalString title = new GrowableInternationalString();
            title.add(Locale.ITALIAN, "italian title");
            wmsInfo.setInternationalTitle((InternationalString)title);
            this.getGeoServer().save(wmsInfo);
            MetadataMap metadata = serviceInfo.getMetadata();
            InspireTestSupport.clearInspireMetadata(metadata);
            metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
            metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
            metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
            metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
            metadata.put(InspireMetadata.OTHER_LANGUAGES.key, (Serializable)((Object)"ita,eng"));
            this.getGeoServer().save(serviceInfo);
            Document dom = this.getAsDOM("wms?request=GetCapabilities&service=WMS&version=1.3.0&LANGUAGE=ita");
            NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_vs/1.0", "ExtendedCapabilities");
            Element extendedCaps = (Element)nodeList.item(0);
            Element suppLangs = (Element)extendedCaps.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "ResponseLanguage").item(0);
            String language = null;
            for (int i = 0; i < suppLangs.getChildNodes().getLength(); ++i) {
                Node el = suppLangs.getChildNodes().item(i);
                if (!this.isLangNode(el)) continue;
                language = el.getTextContent();
            }
            Assert.assertEquals((Object)"ita", language);
        }
        finally {
            this.getGeoServer().save(serviceInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResponseLanguageIsDefault() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        try {
            ServiceInfo wmsInfo = this.getGeoServer().getService(WMSInfo.class);
            GrowableInternationalString title = new GrowableInternationalString();
            title.add(Locale.GERMAN, "de title");
            wmsInfo.setInternationalTitle((InternationalString)title);
            this.getGeoServer().save(wmsInfo);
            MetadataMap metadata = serviceInfo.getMetadata();
            InspireTestSupport.clearInspireMetadata(metadata);
            metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
            metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
            metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
            metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
            metadata.put(InspireMetadata.OTHER_LANGUAGES.key, (Serializable)((Object)"ita,eng"));
            this.getGeoServer().save(serviceInfo);
            Document dom = this.getAsDOM("wms?request=GetCapabilities&service=WMS&version=1.3.0&LANGUAGE=ger");
            NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_vs/1.0", "ExtendedCapabilities");
            Element extendedCaps = (Element)nodeList.item(0);
            Element suppLangs = (Element)extendedCaps.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "ResponseLanguage").item(0);
            String language = null;
            for (int i = 0; i < suppLangs.getChildNodes().getLength(); ++i) {
                Node el = suppLangs.getChildNodes().item(i);
                if (!this.isLangNode(el)) continue;
                language = el.getTextContent();
            }
            Assert.assertEquals((Object)"fre", language);
        }
        finally {
            this.getGeoServer().save(serviceInfo);
        }
    }

    @Test
    public void testResponseLanguageIsDefault2() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.OTHER_LANGUAGES.key, (Serializable)((Object)"ita,eng"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WMS_1_3_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_vs/1.0", "ExtendedCapabilities");
        Element extendedCaps = (Element)nodeList.item(0);
        Element suppLangs = (Element)extendedCaps.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "ResponseLanguage").item(0);
        String language = null;
        for (int i = 0; i < suppLangs.getChildNodes().getLength(); ++i) {
            Node el = suppLangs.getChildNodes().item(i);
            if (!this.isLangNode(el)) continue;
            language = el.getTextContent();
        }
        Assert.assertEquals((Object)"fre", language);
        Element supportedLanguage = (Element)extendedCaps.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "SupportedLanguage").item(0);
        String nodeName = "";
        for (int i = 0; i < supportedLanguage.getChildNodes().getLength(); ++i) {
            Node el = supportedLanguage.getChildNodes().item(i);
            if (!this.isLangNode(el)) continue;
            language = el.getTextContent();
            nodeName = el.getNodeName();
        }
        Assert.assertEquals((Object)"ita", (Object)language);
        Assert.assertEquals((Object)"inspire_common:Language", (Object)nodeName);
    }

    @Test
    public void testSupportedLanguageIsNull() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WMS_1_3_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_vs/1.0", "ExtendedCapabilities");
        Element extendedCaps = (Element)nodeList.item(0);
        Element supportedLanguage = (Element)extendedCaps.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "SupportedLanguage").item(0);
        Assert.assertNull((Object)supportedLanguage);
    }

    @Test
    public void testUnSupportedLanguages() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        GrowableInternationalString title = new GrowableInternationalString();
        title.add(Locale.ITALIAN, "italian title");
        title.add(Locale.FRENCH, "french title");
        serviceInfo.setDefaultLocale(Locale.FRENCH);
        serviceInfo.setInternationalTitle((InternationalString)title);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.OTHER_LANGUAGES.key, (Serializable)((Object)"ita,eng"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM("wms?request=GetCapabilities&service=WMS&version=1.3.0&LANGUAGE=unsupported");
        String responseLanguage = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "ResponseLanguage").item(0).getFirstChild().getNextSibling().getFirstChild().getNodeValue();
        Assert.assertEquals((String)"Unsupported LANGUAGE returns the Default one", (Object)"fre", (Object)responseLanguage);
        String xPathExpression = "//*[local-name()='WMS_Capabilities']/*[local-name()='Service']/*[local-name()='Title']";
        XMLAssert.assertXpathEvaluatesTo((String)"french title", (String)xPathExpression, (Document)dom);
    }

    private boolean isLangNode(Node el) {
        return el != null && el.getLocalName() != null && el.getLocalName().equals("Language");
    }
}

