/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire;

import org.geoserver.inspire.UniqueResourceIdentifier;
import org.geoserver.inspire.UniqueResourceIdentifiers;
import org.geotools.util.Converters;
import org.junit.Assert;
import org.junit.Test;

public class InspireConverterFactoryTest {
    @Test
    public void testCodeOnly() {
        UniqueResourceIdentifiers ids = new UniqueResourceIdentifiers();
        ids.add((Object)new UniqueResourceIdentifier("code"));
        String str = (String)Converters.convert((Object)ids, String.class);
        Assert.assertEquals((Object)"code,,", (Object)str);
        UniqueResourceIdentifiers ids2 = (UniqueResourceIdentifiers)Converters.convert((Object)str, UniqueResourceIdentifiers.class);
        Assert.assertEquals((Object)ids, (Object)ids2);
    }

    @Test
    public void testCodeNamespace() {
        UniqueResourceIdentifiers ids = new UniqueResourceIdentifiers();
        ids.add((Object)new UniqueResourceIdentifier("code", "http://www.geoserver.org"));
        String str = (String)Converters.convert((Object)ids, String.class);
        Assert.assertEquals((Object)"code,http://www.geoserver.org,", (Object)str);
        UniqueResourceIdentifiers ids2 = (UniqueResourceIdentifiers)Converters.convert((Object)str, UniqueResourceIdentifiers.class);
        Assert.assertEquals((Object)ids, (Object)ids2);
    }

    @Test
    public void testCodeMetadata() {
        UniqueResourceIdentifiers ids = new UniqueResourceIdentifiers();
        ids.add((Object)new UniqueResourceIdentifier("code", null, "http://metadata.geoserver.org/id?code"));
        String str = (String)Converters.convert((Object)ids, String.class);
        Assert.assertEquals((Object)"code,,http://metadata.geoserver.org/id?code", (Object)str);
        UniqueResourceIdentifiers ids2 = (UniqueResourceIdentifiers)Converters.convert((Object)str, UniqueResourceIdentifiers.class);
        Assert.assertEquals((Object)ids, (Object)ids2);
    }

    @Test
    public void testCodeNamespaceMetadata() {
        UniqueResourceIdentifiers ids = new UniqueResourceIdentifiers();
        ids.add((Object)new UniqueResourceIdentifier("code", "http://www.geoserver.org", "http://www.geoserver.org/metadata"));
        String str = (String)Converters.convert((Object)ids, String.class);
        Assert.assertEquals((Object)"code,http://www.geoserver.org,http://www.geoserver.org/metadata", (Object)str);
        UniqueResourceIdentifiers ids2 = (UniqueResourceIdentifiers)Converters.convert((Object)str, UniqueResourceIdentifiers.class);
        Assert.assertEquals((Object)ids, (Object)ids2);
    }

    @Test
    public void testMulti() {
        UniqueResourceIdentifiers ids = new UniqueResourceIdentifiers();
        ids.add((Object)new UniqueResourceIdentifier("code1"));
        ids.add((Object)new UniqueResourceIdentifier("code2", "http://www.geoserver.org/1"));
        ids.add((Object)new UniqueResourceIdentifier("code3", "http://www.geoserver.org/2", "http://www.geoserver.org/metadata"));
        String str = (String)Converters.convert((Object)ids, String.class);
        Assert.assertEquals((Object)"code1,,;code2,http://www.geoserver.org/1,;code3,http://www.geoserver.org/2,http://www.geoserver.org/metadata", (Object)str);
        UniqueResourceIdentifiers ids2 = (UniqueResourceIdentifiers)Converters.convert((Object)str, UniqueResourceIdentifiers.class);
        Assert.assertEquals((Object)ids, (Object)ids2);
    }
}

