/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire;

import java.util.HashMap;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.inspire.InspireMetadata;
import org.geoserver.inspire.UniqueResourceIdentifier;
import org.geoserver.inspire.UniqueResourceIdentifiers;
import org.junit.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class InspireTestSupport {
    public static void clearInspireMetadata(MetadataMap metadata) {
        for (InspireMetadata item : InspireMetadata.values()) {
            metadata.remove((Object)item.key);
        }
    }

    public static void assertSchemaLocationContains(String schemaLocation, String namespace, String url) {
        Assert.assertTrue((boolean)schemaLocation.contains(namespace));
        String[] schemaLocationParts = schemaLocation.split("\\s+");
        for (int i = 0; i < schemaLocationParts.length; ++i) {
            if (!schemaLocationParts[i].equals(namespace)) continue;
            Assert.assertEquals((Object)schemaLocationParts[i + 1], (Object)url);
        }
    }

    public static void assertInspireCommonScenario1Response(Element extendedCapabilities, String metadataUrl, String mediaType, String language) {
        NodeList nodeList = extendedCapabilities.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "MetadataUrl");
        Assert.assertEquals((String)"Number of MetadataUrl elements", (long)1L, (long)nodeList.getLength());
        Element mdUrl = (Element)nodeList.item(0);
        InspireTestSupport.assertInspireMetadataUrlResponse(mdUrl, metadataUrl, mediaType);
        nodeList = extendedCapabilities.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "SupportedLanguages");
        Assert.assertEquals((String)"Number of SupportedLanguages elements", (long)1L, (long)nodeList.getLength());
        Element suppLangs = (Element)nodeList.item(0);
        nodeList = suppLangs.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "DefaultLanguage");
        Assert.assertEquals((String)"Number of DefaultLanguage elements", (long)1L, (long)nodeList.getLength());
        Element defLang = (Element)nodeList.item(0);
        nodeList = defLang.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "Language");
        Assert.assertEquals((String)"Number of DefaultLanguage/Language elements", (long)1L, (long)nodeList.getLength());
        Element defLangVal = (Element)nodeList.item(0);
        Assert.assertEquals((String)"DefaultLanguage/Language", (Object)language, (Object)defLangVal.getFirstChild().getNodeValue());
        nodeList = extendedCapabilities.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "ResponseLanguage");
        Assert.assertEquals((String)"Number of ResponseLanguage elements", (long)1L, (long)nodeList.getLength());
        Element respLang = (Element)nodeList.item(0);
        nodeList = respLang.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "Language");
        Assert.assertEquals((String)"Number of ResponseLanguage/Language elements", (long)1L, (long)nodeList.getLength());
        Element respLangVal = (Element)nodeList.item(0);
        Assert.assertEquals((String)"ResponseLanguage/Language", (Object)language, (Object)respLangVal.getFirstChild().getNodeValue());
    }

    public static void assertInspireMetadataUrlResponse(Element mdUrl, String metadataUrl, String mediaType) {
        NodeList nodeList = mdUrl.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "URL");
        Assert.assertEquals((String)"Number of URL elements", (long)1L, (long)nodeList.getLength());
        Element url = (Element)nodeList.item(0);
        Assert.assertEquals((String)"MetadataUrl/URL", (Object)metadataUrl, (Object)url.getFirstChild().getNodeValue());
        nodeList = mdUrl.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "MediaType");
        if (mediaType == null) {
            Assert.assertEquals((String)"Number of MediaType elements", (long)0L, (long)nodeList.getLength());
        } else {
            Assert.assertEquals((String)"Number of MediaType elements", (long)1L, (long)nodeList.getLength());
            Assert.assertEquals((String)"MediaType", (Object)mediaType, (Object)nodeList.item(0).getFirstChild().getNodeValue());
        }
    }

    public static void assertInspireDownloadSpatialDataSetIdentifierResponse(Element extendedCapabilities, UniqueResourceIdentifiers ids) {
        NodeList spatialDataSetIdentifiers = extendedCapabilities.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_dls/1.0", "SpatialDataSetIdentifier");
        Assert.assertEquals((String)"Number of SpatialDataSetIdentifer elements", (long)ids.size(), (long)spatialDataSetIdentifiers.getLength());
        HashMap<String, UniqueResourceIdentifier> idMap = new HashMap<String, UniqueResourceIdentifier>();
        for (UniqueResourceIdentifier id : ids) {
            idMap.put(id.getCode(), id);
        }
        for (int i = 0; i < spatialDataSetIdentifiers.getLength(); ++i) {
            Element sdi = (Element)spatialDataSetIdentifiers.item(i);
            NodeList nodeList = sdi.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "Code");
            Assert.assertEquals((String)"Number of Code elements", (long)1L, (long)nodeList.getLength());
            String code = nodeList.item(0).getFirstChild().getNodeValue();
            Assert.assertTrue((String)("Should be an identifier with code " + code), (boolean)idMap.containsKey(code));
            nodeList = sdi.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "Namespace");
            String expectedNamespace = ((UniqueResourceIdentifier)idMap.get(code)).getNamespace();
            if (expectedNamespace == null) {
                Assert.assertEquals((String)("Number of Namespace elements for identifier with code " + code), (long)0L, (long)nodeList.getLength());
            } else {
                Assert.assertEquals((String)("Number of Namespace elements for identifier with code " + code), (long)1L, (long)nodeList.getLength());
                String actualNamespace = nodeList.item(0).getFirstChild().getNodeValue();
                Assert.assertEquals((String)("Namespace for identifier with code " + code), (Object)expectedNamespace, (Object)actualNamespace);
            }
            String expectedMetadataUrl = ((UniqueResourceIdentifier)idMap.get(code)).getMetadataURL();
            String actualMetadataUrl = sdi.getAttribute("metadataURL");
            if (expectedMetadataUrl == null) {
                expectedMetadataUrl = "";
            }
            Assert.assertEquals((String)("metadataURL attribute for identifer with code" + code), (Object)expectedMetadataUrl, (Object)actualMetadataUrl);
        }
    }
}

