/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire;

import java.io.Serializable;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.ServiceInfo;
import org.geoserver.inspire.InspireMetadata;
import org.geoserver.inspire.InspireTestSupport;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class ServicesTestSupport
extends GeoServerSystemTestSupport {
    protected abstract String getGetCapabilitiesRequestPath();

    protected abstract String getMetadataUrl();

    protected abstract String getMetadataType();

    protected abstract String getLanguage();

    protected abstract String getAlternateMetadataType();

    protected abstract ServiceInfo getServiceInfo();

    protected abstract String getInspireNameSpace();

    protected abstract String getInspireSchema();

    @Test
    public void testNoInspireSettings() throws Exception {
        ServiceInfo serviceInfo = this.getServiceInfo();
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(this.getGetCapabilitiesRequestPath());
        NodeList nodeList = dom.getElementsByTagNameNS(this.getInspireNameSpace(), "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)0L, (long)nodeList.getLength());
    }

    @Test
    public void testCreateExtCapsOff() throws Exception {
        ServiceInfo serviceInfo = this.getServiceInfo();
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(false));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)this.getMetadataUrl()));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)this.getMetadataType()));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)this.getLanguage()));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(this.getGetCapabilitiesRequestPath());
        NodeList nodeList = dom.getElementsByTagNameNS(this.getInspireNameSpace(), "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)0L, (long)nodeList.getLength());
    }

    @Test
    public void testExtCapsWithFullSettings() throws Exception {
        ServiceInfo serviceInfo = this.getServiceInfo();
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)this.getMetadataUrl()));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)this.getMetadataType()));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)this.getLanguage()));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(this.getGetCapabilitiesRequestPath());
        NodeList nodeList = dom.getElementsByTagNameNS(this.getInspireNameSpace(), "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)1L, (long)nodeList.getLength());
        String schemaLocation = dom.getDocumentElement().getAttribute("xsi:schemaLocation");
        InspireTestSupport.assertSchemaLocationContains(schemaLocation, this.getInspireNameSpace(), this.getInspireSchema());
        Element extendedCaps = (Element)nodeList.item(0);
        InspireTestSupport.assertInspireCommonScenario1Response(extendedCaps, this.getMetadataUrl(), this.getMetadataType(), this.getLanguage());
    }

    @Test
    public void testReloadSettings() throws Exception {
        ServiceInfo serviceInfo = this.getServiceInfo();
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)this.getMetadataUrl()));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)this.getMetadataType()));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)this.getLanguage()));
        this.getGeoServer().save(serviceInfo);
        this.getGeoServer().reload();
        Document dom = this.getAsDOM(this.getGetCapabilitiesRequestPath());
        NodeList nodeList = dom.getElementsByTagNameNS(this.getInspireNameSpace(), "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements after settings reload", (long)1L, (long)nodeList.getLength());
    }

    @Test
    public void testNoMetadataUrl() throws Exception {
        ServiceInfo serviceInfo = this.getServiceInfo();
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)this.getMetadataType()));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)this.getLanguage()));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(this.getGetCapabilitiesRequestPath());
        NodeList nodeList = dom.getElementsByTagNameNS(this.getInspireNameSpace(), "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)0L, (long)nodeList.getLength());
    }

    @Test
    public void testNoMediaType() throws Exception {
        ServiceInfo serviceInfo = this.getServiceInfo();
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)this.getMetadataUrl()));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)this.getLanguage()));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(this.getGetCapabilitiesRequestPath());
        NodeList nodeList = dom.getElementsByTagNameNS(this.getInspireNameSpace(), "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)1L, (long)nodeList.getLength());
        nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "MediaType");
        Assert.assertEquals((String)"Number of MediaType elements", (long)0L, (long)nodeList.getLength());
    }

    @Test
    public void testCreateExtCapMissingWithRequiredSettings() throws Exception {
        ServiceInfo serviceInfo = this.getServiceInfo();
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)this.getMetadataUrl()));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)this.getMetadataType()));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)this.getLanguage()));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(this.getGetCapabilitiesRequestPath());
        NodeList nodeList = dom.getElementsByTagNameNS(this.getInspireNameSpace(), "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)1L, (long)nodeList.getLength());
    }

    @Test
    public void testCreateExtCapMissingWithoutRequiredSettings() throws Exception {
        ServiceInfo serviceInfo = this.getServiceInfo();
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)this.getMetadataType()));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)this.getLanguage()));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(this.getGetCapabilitiesRequestPath());
        NodeList nodeList = dom.getElementsByTagNameNS(this.getInspireNameSpace(), "ExtendedCapabilities");
        Assert.assertEquals((String)"Number of INSPIRE ExtendedCapabilities elements", (long)0L, (long)nodeList.getLength());
    }

    @Test
    public void testChangeMediaType() throws Exception {
        ServiceInfo serviceInfo = this.getServiceInfo();
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)this.getMetadataUrl()));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)this.getMetadataType()));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)this.getLanguage()));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(this.getGetCapabilitiesRequestPath());
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "MetadataUrl");
        Assert.assertEquals((String)"Number of MediaType elements", (long)1L, (long)nodeList.getLength());
        Element mdUrl = (Element)nodeList.item(0);
        InspireTestSupport.assertInspireMetadataUrlResponse(mdUrl, this.getMetadataUrl(), this.getMetadataType());
        serviceInfo.getMetadata().put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)this.getAlternateMetadataType()));
        this.getGeoServer().save(serviceInfo);
        dom = this.getAsDOM(this.getGetCapabilitiesRequestPath());
        nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "MetadataUrl");
        Assert.assertEquals((String)"Number of MediaType elements", (long)1L, (long)nodeList.getLength());
        mdUrl = (Element)nodeList.item(0);
        InspireTestSupport.assertInspireMetadataUrlResponse(mdUrl, this.getMetadataUrl(), this.getAlternateMetadataType());
    }
}

