/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire.web;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.ValidationErrorFeedback;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.inspire.UniqueResourceIdentifiers;
import org.geoserver.inspire.web.UniqueResourceIdentifiersEditor;
import org.geoserver.web.ComponentBuilder;
import org.geoserver.web.FormTestPage;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.util.Converters;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UniqueResourceIdentifiersEditorTest
extends GeoServerWicketTestSupport {
    private UniqueResourceIdentifiers identifiers;

    @Before
    public void setupPanel() {
        this.identifiers = (UniqueResourceIdentifiers)Converters.convert((Object)"one,http://www.geoserver.org/one;two,http://www.geoserver.org/two,http://metadata.geoserver.org/id?two", UniqueResourceIdentifiers.class);
        tester.startPage((Page)new FormTestPage((ComponentBuilder & Serializable)id -> new UniqueResourceIdentifiersEditor(id, (IModel)new Model((Serializable)this.identifiers))));
    }

    @Test
    public void testContents() {
        tester.assertComponent("form", Form.class);
        tester.assertModelValue("form:panel:container:identifiers:listContainer:items:1:itemProperties:0:component:border:border_body:txt", (Object)"one");
        tester.assertModelValue("form:panel:container:identifiers:listContainer:items:1:itemProperties:1:component:border:border_body:txt", (Object)"http://www.geoserver.org/one");
        tester.assertModelValue("form:panel:container:identifiers:listContainer:items:1:itemProperties:2:component:border:border_body:txt", null);
        tester.assertModelValue("form:panel:container:identifiers:listContainer:items:2:itemProperties:0:component:border:border_body:txt", (Object)"two");
        tester.assertModelValue("form:panel:container:identifiers:listContainer:items:2:itemProperties:1:component:border:border_body:txt", (Object)"http://www.geoserver.org/two");
        tester.assertModelValue("form:panel:container:identifiers:listContainer:items:2:itemProperties:2:component:border:border_body:txt", (Object)"http://metadata.geoserver.org/id?two");
    }

    @Test
    public void testRemoveLinks() {
        tester.assertComponent("form", Form.class);
        tester.assertModelValue("form:panel:container:identifiers:listContainer:items:1:itemProperties:0:component:border:border_body:txt", (Object)"one");
        tester.assertModelValue("form:panel:container:identifiers:listContainer:items:2:itemProperties:0:component:border:border_body:txt", (Object)"two");
        tester.executeAjaxEvent("form:panel:container:identifiers:listContainer:items:1:itemProperties:3:component:remove", "click");
        Assert.assertNull((Object)tester.getLastRenderedPage().get("form:panel:container:identifiers:listContainer:items:1:itemProperties:0:component:border:border_body:txt"));
        tester.assertModelValue("form:panel:container:identifiers:listContainer:items:2:itemProperties:0:component:border:border_body:txt", (Object)"two");
        tester.executeAjaxEvent("form:panel:container:identifiers:listContainer:items:2:itemProperties:3:component:remove", "click");
        Assert.assertNull((Object)tester.getLastRenderedPage().get("form:panel:container:identifiers:listContainer:items:1:itemProperties:0:component:border:border_body:txt"));
        Assert.assertNull((Object)tester.getLastRenderedPage().get("form:panel:container:identifiers:listContainer:items:2:itemProperties:0:component:border:border_body:txt"));
        tester.submitForm("form");
        String error = new ParamResourceModel("UniqueResourceIdentifiersEditor.noSpatialDatasetIdentifiers", null, new Object[0]).getString();
        tester.assertErrorMessages((Serializable[])new String[]{error});
    }

    @Test
    public void testAddIdentifiers() {
        tester.executeAjaxEvent("form:panel:addIdentifier", "click");
        tester.assertModelValue("form:panel:container:identifiers:listContainer:items:3:itemProperties:0:component:border:border_body:txt", null);
        tester.assertModelValue("form:panel:container:identifiers:listContainer:items:3:itemProperties:1:component:border:border_body:txt", null);
        FormTester ft = tester.newFormTester("form");
        ft.submit();
        List messages = tester.getMessages(400);
        Assert.assertEquals((long)1L, (long)messages.size());
        String message = (String)((Object)((ValidationErrorFeedback)messages.get(0)).getMessage());
        Assert.assertTrue((boolean)message.contains("Code"));
        ft = tester.newFormTester("form");
        ft.setValue("panel:container:identifiers:listContainer:items:3:itemProperties:0:component:border:border_body:txt", "code");
        ft.submit();
        tester.assertNoErrorMessage();
        tester.assertModelValue("form:panel:container:identifiers:listContainer:items:3:itemProperties:0:component:border:border_body:txt", (Object)"code");
        ft = tester.newFormTester("form");
        ft.setValue("panel:container:identifiers:listContainer:items:3:itemProperties:1:component:border:border_body:txt", "invalid uri");
        ft.submit();
        messages = tester.getMessages(400);
        Assert.assertEquals((long)1L, (long)messages.size());
        ft = tester.newFormTester("form");
        ft.setValue("panel:container:identifiers:listContainer:items:3:itemProperties:1:component:border:border_body:txt", "http://www.geoserver.org/meta");
        ft.submit();
        tester.assertNoErrorMessage();
        tester.assertModelValue("form:panel:container:identifiers:listContainer:items:3:itemProperties:1:component:border:border_body:txt", (Object)"http://www.geoserver.org/meta");
        ft = tester.newFormTester("form");
        ft.setValue("panel:container:identifiers:listContainer:items:3:itemProperties:2:component:border:border_body:txt", "invalid uri");
        ft.submit();
        messages = tester.getMessages(400);
        Assert.assertEquals((long)1L, (long)messages.size());
        ft = tester.newFormTester("form");
        ft.setValue("panel:container:identifiers:listContainer:items:3:itemProperties:2:component:border:border_body:txt", "http://www.geoserver.org/meta");
        ft.submit();
        tester.assertNoErrorMessage();
        tester.assertModelValue("form:panel:container:identifiers:listContainer:items:3:itemProperties:2:component:border:border_body:txt", (Object)"http://www.geoserver.org/meta");
    }
}

