/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire.wmts;

import java.io.Serializable;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.ServiceInfo;
import org.geoserver.gwc.wmts.WMTSInfo;
import org.geoserver.inspire.InspireMetadata;
import org.geoserver.inspire.InspireTestSupport;
import org.geoserver.inspire.ServicesTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WMTSExtendedCapabilitiesTest
extends ServicesTestSupport {
    private static final String WMTS_1_0_0_GETCAPREQUEST = "gwc/service/wmts?REQUEST=GetCapabilities";

    @Override
    protected String getGetCapabilitiesRequestPath() {
        return WMTS_1_0_0_GETCAPREQUEST;
    }

    @Override
    protected String getMetadataUrl() {
        return "http://foo.com?bar=baz";
    }

    @Override
    protected String getMetadataType() {
        return "application/vnd.iso.19139+xml";
    }

    @Override
    protected String getLanguage() {
        return "fre";
    }

    @Override
    protected String getAlternateMetadataType() {
        return "application/vnd.ogc.csw.GetRecordByIdResponse_xml";
    }

    @Override
    protected ServiceInfo getServiceInfo() {
        return this.getGeoServer().getService(WMTSInfo.class);
    }

    @Override
    protected String getInspireNameSpace() {
        return "http://inspire.ec.europa.eu/schemas/inspire_vs_ows11/1.0";
    }

    @Override
    protected String getInspireSchema() {
        return "http://inspire.ec.europa.eu/schemas/inspire_vs_ows11/1.0/inspire_vs_ows_11.xsd";
    }

    @Test
    public void testSupportedLanguages() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMTSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.OTHER_LANGUAGES.key, (Serializable)((Object)"ita,eng"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM(WMTS_1_0_0_GETCAPREQUEST);
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_vs_ows11/1.0", "ExtendedCapabilities");
        Element extendedCaps = (Element)nodeList.item(0);
        Element suppLangs = (Element)extendedCaps.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "SupportedLanguages").item(0);
        nodeList = suppLangs.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "DefaultLanguage");
        Assert.assertEquals((String)"Number of DefaultLanguage elements", (long)1L, (long)nodeList.getLength());
        nodeList = suppLangs.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "SupportedLanguage");
        Assert.assertEquals((String)"Number of Supported Languages", (long)2L, (long)nodeList.getLength());
    }

    @Test
    public void testUnSupportedLanguages() throws Exception {
        ServiceInfo serviceInfo = this.getGeoServer().getService(WMTSInfo.class);
        MetadataMap metadata = serviceInfo.getMetadata();
        InspireTestSupport.clearInspireMetadata(metadata);
        metadata.put(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, (Serializable)Boolean.valueOf(true));
        metadata.put(InspireMetadata.SERVICE_METADATA_URL.key, (Serializable)((Object)"http://foo.com?bar=baz"));
        metadata.put(InspireMetadata.SERVICE_METADATA_TYPE.key, (Serializable)((Object)"application/vnd.iso.19139+xml"));
        metadata.put(InspireMetadata.LANGUAGE.key, (Serializable)((Object)"fre"));
        metadata.put(InspireMetadata.OTHER_LANGUAGES.key, (Serializable)((Object)"ita,eng"));
        this.getGeoServer().save(serviceInfo);
        Document dom = this.getAsDOM("gwc/service/wmts?REQUEST=GetCapabilities&LANGUAGE=unsupported");
        NodeList nodeList = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/inspire_vs_ows11/1.0", "ExtendedCapabilities");
        Element extendedCaps = (Element)nodeList.item(0);
        Element suppLangs = (Element)extendedCaps.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "SupportedLanguages").item(0);
        nodeList = suppLangs.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "DefaultLanguage");
        Assert.assertEquals((String)"Number of DefaultLanguage elements", (long)1L, (long)nodeList.getLength());
        nodeList = suppLangs.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "SupportedLanguage");
        Assert.assertEquals((String)"Number of Supported Languages", (long)2L, (long)nodeList.getLength());
        String responseLanguage = dom.getElementsByTagNameNS("http://inspire.ec.europa.eu/schemas/common/1.0", "ResponseLanguage").item(0).getFirstChild().getNextSibling().getFirstChild().getNodeValue();
        Assert.assertEquals((String)"Unsupported LANGUAGE returns the Default one", (Object)"fre", (Object)responseLanguage);
    }
}

