/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.geoserver.inspire.InspireDirectoryManager;
import org.geoserver.ows.AbstractDispatcherCallback;
import org.geoserver.ows.Request;

public class LanguagesDispatcherCallback
extends AbstractDispatcherCallback {
    static final String LANGUAGE_PARAM = "LANGUAGE";
    static final String ACCEPT_LANGUAGES_PARAM = "ACCEPTLANGUAGES";

    public Request init(Request request) {
        Map rawKvp = request.getRawKvp();
        if (rawKvp != null && rawKvp.containsKey(LANGUAGE_PARAM)) {
            String value = String.valueOf(rawKvp.get(LANGUAGE_PARAM));
            try {
                Properties mappings = InspireDirectoryManager.get().getLanguagesMappings();
                String isoLang = mappings.getProperty(value);
                rawKvp.put(ACCEPT_LANGUAGES_PARAM, isoLang);
                rawKvp.put(LANGUAGE_PARAM, isoLang != null ? isoLang : "");
                if (request.getKvp() != null) {
                    request.getKvp().put(ACCEPT_LANGUAGES_PARAM, isoLang);
                    request.getKvp().put(LANGUAGE_PARAM, isoLang);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return super.init(request);
    }
}

