/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.inspire.wms;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.geoserver.ExtendedCapabilitiesProvider;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.inspire.InspireMetadata;
import org.geoserver.inspire.ServicesUtils;
import org.geoserver.wms.ExtendedCapabilitiesProvider;
import org.geoserver.wms.GetCapabilitiesRequest;
import org.geoserver.wms.WMS;
import org.geoserver.wms.WMSInfo;
import org.geotools.util.NumberRange;
import org.geotools.util.Version;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class WMSExtendedCapabilitiesProvider
implements ExtendedCapabilitiesProvider {
    public String[] getSchemaLocations(String schemaBaseURL) {
        return new String[]{"http://inspire.ec.europa.eu/schemas/inspire_vs/1.0", "https://inspire.ec.europa.eu/schemas/inspire_vs/1.0/inspire_vs.xsd"};
    }

    public List<String> getVendorSpecificCapabilitiesRoots(GetCapabilitiesRequest request) {
        return Collections.emptyList();
    }

    public List<String> getVendorSpecificCapabilitiesChildDecls(GetCapabilitiesRequest request) {
        return Collections.emptyList();
    }

    public void registerNamespaces(NamespaceSupport namespaces) {
        ServicesUtils.registerNameSpaces(namespaces);
    }

    public void encode(ExtendedCapabilitiesProvider.Translator tx, WMSInfo wms, GetCapabilitiesRequest request) throws IOException {
        Version requestVersion = WMS.version((String)request.getVersion());
        if (!WMS.VERSION_1_3_0.equals((Object)requestVersion)) {
            return;
        }
        MetadataMap serviceMetadata = wms.getMetadata();
        Boolean createExtendedCapabilities = (Boolean)serviceMetadata.get(InspireMetadata.CREATE_EXTENDED_CAPABILITIES.key, Boolean.class);
        String metadataURL = (String)((Object)serviceMetadata.get((Object)InspireMetadata.SERVICE_METADATA_URL.key));
        if (metadataURL == null || createExtendedCapabilities != null && !createExtendedCapabilities.booleanValue()) {
            return;
        }
        String mediaType = (String)((Object)serviceMetadata.get((Object)InspireMetadata.SERVICE_METADATA_TYPE.key));
        ServicesUtils.addScenario1Elements(tx, metadataURL, mediaType, serviceMetadata);
    }

    Attributes atts(String ... atts) {
        AttributesImpl attributes = new AttributesImpl();
        for (int i = 0; i < atts.length; i += 2) {
            attributes.addAttribute(null, atts[i], atts[i], null, atts[i + 1]);
        }
        return attributes;
    }

    public void customizeRootCrsList(Set<String> srs) {
    }

    public NumberRange<Double> overrideScaleDenominators(PublishedInfo layer, NumberRange<Double> scaleDenominators) {
        return scaleDenominators;
    }
}

