/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.community.mbstyle.web;

import org.apache.wicket.Page;
import org.apache.wicket.util.tester.FormTester;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.impl.StyleInfoImpl;
import org.geoserver.web.GeoServerWicketTestSupport;
import org.geoserver.wms.web.data.OpenLayersPreviewPanel;
import org.geoserver.wms.web.data.StyleEditPage;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MBStyleEditPageTest
extends GeoServerWicketTestSupport {
    StyleInfo mbstyle;
    StyleEditPage edit;

    @Before
    public void setUp() throws Exception {
        Catalog catalog = this.getCatalog();
        this.login();
        this.mbstyle = new StyleInfoImpl(null);
        this.mbstyle.setName("mbstyle");
        this.mbstyle.setFilename("mbstyle.json");
        this.mbstyle.setFormat("mbstyle");
        catalog.add(this.mbstyle);
        this.mbstyle = catalog.getStyleByName("mbstyle");
        catalog.save(this.mbstyle);
        this.edit = new StyleEditPage(this.mbstyle);
        tester.startPage((Page)this.edit);
    }

    @Test
    public void testMbstyleChange() throws Exception {
        String json = "{\n  \"version\": 8, \n  \"name\": \"places\",\n  \"sprite\": \"http://localhost:8080/geoserver/styles/mbsprites\",\n  \"layers\": [\n    {\n      \"id\": \"circle\",\n      \"source-layer\": \"Buildings\",\n      \"type\": \"symbol\",\n      \"layout\": {\n        \"icon-image\": \"circle\",\n        \"icon-size\": {\n          \"property\": \"POP_MAX\",\n          \"type\": \"exponential\",\n          \"stops\": [\n            [0, 0.7],\n            [40000000, 3.7]\n          ]\n        }\n      }\n    }\n  ]\n }\n";
        FormTester form = tester.newFormTester("styleForm");
        form.setValue("context:panel:format", "mbstyle");
        form.setValue("context:panel:name", "mbstyleTest");
        tester.executeAjaxEvent("apply", "click");
        tester.executeAjaxEvent("styleForm:context:tabs-container:tabs:2:link", "click");
        tester.assertComponent("styleForm:context:panel", OpenLayersPreviewPanel.class);
        tester.assertModelValue("styleForm:context:panel:previewStyleGroup", (Object)false);
        form.setValue("context:panel:previewStyleGroup", true);
        form.setValue("styleEditor:editorContainer:editorParent:editor", json);
        tester.executeAjaxEvent("apply", "click");
        tester.assertModelValue("styleForm:context:panel:previewStyleGroup", (Object)true);
        Assert.assertNotNull((Object)this.getCatalog().getStyleByName("mbstyle").getSLD());
        Style style = this.getCatalog().getStyleByName("mbstyle").getStyle();
        Symbolizer sym = (Symbolizer)((Rule)((FeatureTypeStyle)style.featureTypeStyles().get(0)).rules().get(0)).symbolizers().get(0);
        TextSymbolizer label = (TextSymbolizer)sym;
        ExternalGraphic eg = (ExternalGraphic)label.getGraphic().graphicalSymbols().get(0);
        Assert.assertEquals((Object)eg.getURI(), (Object)"http://localhost:8080/geoserver/styles/mbsprites#icon=${strURLEncode('circle')}&size=${strURLEncode(Interpolate(POP_MAX,0,0.7,40000000,3.7,'numeric'))}");
    }
}

