/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.GeoServerPluginConfigurator;
import org.geoserver.monitor.MemoryMonitorDAO;
import org.geoserver.monitor.MonitorDAO;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Paths;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.security.PropertyFileWatcher;
import org.geoserver.util.IOUtils;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.referencing.CRS;
import org.geotools.util.ConverterFactory;
import org.geotools.util.Converters;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class MonitorConfig
implements GeoServerPluginConfigurator,
ApplicationContextAware {
    protected static final String PROPERTYFILENAME = "monitor.properties";
    private static final Logger LOGGER = Logging.getLogger(MonitorConfig.class);
    protected Properties props;
    PropertyFileWatcher fw;
    ApplicationContext context;
    boolean enabled = true;
    Exception error;
    private GeoServerResourceLoader loader;
    static final int POSTPROCES_THREADS_DEFAULT = 2;
    static final String DNS_CACHE_DEFAULT = "expireAfterWrite=15m,maximumSize=1000";

    public MonitorConfig() {
        this.props = new PropertyFileWatcher.LinkedProperties();
        this.props.put("storage", "memory");
        this.props.put("mode", "history");
        this.props.put("maxBodySize", "1024");
        this.props.put("bboxMode", "no_wfs");
        this.props.put("bboxCrs", "EPSG:4326");
        this.props.put("hibernate.sync", "async");
        this.loader = (GeoServerResourceLoader)GeoServerExtensions.bean(GeoServerResourceLoader.class);
    }

    public MonitorConfig(GeoServerResourceLoader loader) throws IOException {
        this.loader = loader;
        Resource f = this.getConfigurationFile(loader);
        this.fw = new PropertyFileWatcher(f);
    }

    public String getStorage() {
        return this.props().getProperty("storage");
    }

    public Properties getProperties() {
        return this.props();
    }

    public Mode getMode() {
        Mode m = Mode.valueOf(this.props().getProperty("mode", "history").toUpperCase());
        return m;
    }

    public long getMaxBodySize() {
        return Long.parseLong(this.props().getProperty("maxBodySize", String.valueOf(1024)));
    }

    public CoordinateReferenceSystem getBboxCrs() {
        Properties props = this.props();
        String srs = props.getProperty("bboxCrs");
        if (srs == null) {
            srs = props.getProperty("bboxLogCrs", "EPSG:4326");
        }
        try {
            return CRS.decode((String)srs);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
            return null;
        }
    }

    public BboxMode getBboxMode() {
        Properties props = this.props();
        String mode = props.getProperty("bboxMode");
        if (mode == null) {
            mode = props.getProperty("bboxLogLevel", "no_wfs");
        }
        if (mode == null) {
            return null;
        }
        return BboxMode.valueOf(mode.toUpperCase());
    }

    public Set<String> getIgnorePostProcessors() {
        String list = this.props.getProperty("ignorePostProcessors");
        if (list == null || list.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(list.split(","))));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public MonitorDAO createDAO() {
        Mode mode;
        MonitorDAO dao = null;
        String storage = this.getStorage();
        if (storage == null && (mode = this.getMode()) == Mode.HISTORY) {
            storage = "hibernate";
        }
        if (storage == null) {
            storage = "memory";
        }
        for (MonitorDAO d : GeoServerExtensions.extensions(MonitorDAO.class)) {
            if (!storage.equalsIgnoreCase(d.getName())) continue;
            dao = d;
            break;
        }
        if (dao == null) {
            LOGGER.warning("monitoring storage " + storage + " not found, falling back to 'memory'");
            dao = new MemoryMonitorDAO();
        }
        dao.init(this);
        return dao;
    }

    public <T> T getProperty(String prefix, String name, Class<T> target) {
        String key = prefix == null ? name : prefix + "." + name;
        Object value = this.props().get(key);
        if (value != null) {
            Object converted = Converters.convert((Object)value, target, (Hints)new Hints((RenderingHints.Key)ConverterFactory.SAFE_CONVERSION, (Object)true));
            if (converted == null) {
                throw new IllegalArgumentException("Object " + value + " could not be converted to the target class " + target);
            }
            return (T)converted;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties props() {
        if (this.fw != null && this.fw.isModified()) {
            MonitorConfig monitorConfig = this;
            synchronized (monitorConfig) {
                if (this.fw.isModified()) {
                    try {
                        this.props = (Properties)this.fw.read();
                        if (this.props.getProperty("sync") != null) {
                            this.props.setProperty("hibernate.sync", this.props.getProperty("sync"));
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.props;
    }

    public List<Resource> getFileLocations() throws IOException {
        ArrayList<Resource> configurationFiles = new ArrayList<Resource>();
        if (this.loader != null) {
            Resource f = this.getConfigurationFile(this.loader);
            configurationFiles.add(f);
        } else if (this.fw != null && this.fw.getResource() != null) {
            configurationFiles.add(this.fw.getResource());
        }
        return configurationFiles;
    }

    public Resource getConfigurationFile(GeoServerResourceLoader loader) throws IOException {
        Resource f = loader.get(Paths.path((String[])new String[]{"monitoring", PROPERTYFILENAME}));
        if (!Resources.exists((Resource)f)) {
            IOUtils.copy((InputStream)MonitorConfig.class.getResourceAsStream(PROPERTYFILENAME), (OutputStream)f.out());
        }
        return f;
    }

    public void saveConfiguration(GeoServerResourceLoader resourceLoader) throws IOException {
        if (this.loader != null) {
            Resource f = this.getConfigurationFile(this.loader);
            Resource targetDir = Files.asResource((File)resourceLoader.findOrCreateDirectory(Paths.convert((File)this.loader.getBaseDirectory(), (File)f.parent().dir())));
            Resources.copy((File)f.file(), (Resource)targetDir);
        } else if (this.fw != null && this.fw.getResource() != null) {
            Resources.copy((File)this.fw.getFile(), (Resource)Files.asResource((File)resourceLoader.getBaseDirectory()));
        } else if (this.props != null) {
            File monitoringConfigurationFile = Resources.file((Resource)resourceLoader.get(PROPERTYFILENAME), (boolean)true);
            try (OutputStream out = Files.out((File)monitoringConfigurationFile);){
                this.props.store(out, "");
                out.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadConfiguration(GeoServerResourceLoader resourceLoader) throws IOException {
        MonitorConfig monitorConfig = this;
        synchronized (monitorConfig) {
            Resource f = this.getConfigurationFile(resourceLoader);
            if (Resources.exists((Resource)f)) {
                this.fw = new PropertyFileWatcher(f);
                this.fw.setKnownLastModified(System.currentTimeMillis());
            }
        }
    }

    public int getPostProcessorThreads() {
        String key;
        Properties props = this.props();
        String svalue = props.getProperty(key = "postProcessorThreads");
        if (svalue != null) {
            try {
                int nvalue = Integer.parseInt(svalue.trim());
                if (nvalue >= 1) {
                    return nvalue;
                }
                LOGGER.warning(key + " is not 1 or more :" + svalue + "!");
            }
            catch (NumberFormatException e) {
                LOGGER.warning(key + " has non-integer value:" + svalue + "!");
            }
        }
        return 2;
    }

    public String getDNSCacheConfiguration() {
        String key;
        Properties props = this.props();
        String value = props.getProperty(key = "dnsCacheConfiguration");
        if (value == null) {
            value = DNS_CACHE_DEFAULT;
        }
        return value;
    }

    public static enum BboxMode {
        NONE,
        NO_WFS,
        FULL;

    }

    public static enum Mode {
        HISTORY,
        LIVE;

    }
}

