/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.filters.GeoServerFilter;
import org.geoserver.monitor.InternalHostname;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.MonitorRequestFilter;
import org.geoserver.monitor.MonitorServletRequest;
import org.geoserver.monitor.MonitorServletResponse;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.RequestPostProcessor;
import org.geoserver.monitor.ReverseDNSPostProcessor;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.SecurityUtils;
import org.geoserver.wms.map.RenderTimeStatistics;
import org.geotools.util.logging.Logging;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class MonitorFilter
implements GeoServerFilter {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.monitor");
    static final String GEOWEBCACHE_CACHE_RESULT = "geowebcache-cache-result";
    static final String GEOWEBCACHE_MISS_REASON = "geowebcache-miss-reason";
    Monitor monitor;
    MonitorRequestFilter requestFilter;
    ExecutorService postProcessExecutor;
    BiConsumer<RequestData, Authentication> executionAudit;

    public MonitorFilter(Monitor monitor, MonitorRequestFilter requestFilter) {
        this.monitor = monitor;
        this.requestFilter = requestFilter;
        this.postProcessExecutor = Executors.newFixedThreadPool(monitor.getConfig().getPostProcessorThreads(), new ThreadFactory(){
            ThreadFactory parent = Executors.defaultThreadFactory();
            int count = 1;

            @Override
            public synchronized Thread newThread(Runnable runnable) {
                Thread t = this.parent.newThread(runnable);
                t.setName("monitor-" + this.count);
                ++this.count;
                return t;
            }
        });
        if (monitor.isEnabled()) {
            LOGGER.info("Monitor extension enabled");
        } else {
            Object msg = "Monitor extension disabled";
            if (monitor.getConfig().getError() != null) {
                msg = (String)msg + ": " + monitor.getConfig().getError().getLocalizedMessage();
            }
            LOGGER.info((String)msg);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Authentication auth;
        String username;
        if (!this.monitor.isEnabled() || !(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (this.requestFilter.filter(req)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(req.getRequestURI() + " was filtered from monitoring");
            }
            chain.doFilter(request, response);
            return;
        }
        RequestData data = this.monitor.start();
        data.setStartTime(new Date());
        data.setPath(req.getServletPath() + req.getPathInfo());
        if (req.getQueryString() != null) {
            data.setQueryString(URLDecoder.decode(req.getQueryString(), "UTF-8"));
        }
        data.setHttpMethod(req.getMethod());
        data.setBodyContentLength(req.getContentLength());
        data.setBodyContentType(req.getContentType());
        String serverName = System.getProperty("http.serverName");
        if (serverName == null) {
            serverName = req.getServerName();
        }
        data.setHost(serverName);
        data.setInternalHost(InternalHostname.get());
        data.setRemoteAddr(this.getRemoteAddr(req));
        data.setStatus(RequestData.Status.RUNNING);
        data.setHttpReferer(this.getHttpReferer(req));
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && (username = SecurityUtils.getUsername((Object)(auth = SecurityContextHolder.getContext().getAuthentication()).getPrincipal())) != null) {
            data.setRemoteUser(username);
        }
        if (data.getRemoteUser() == null || data.getRemoteUser().isEmpty()) {
            data.setRemoteUser(req.getRemoteUser());
        }
        data.setRemoteUserAgent(req.getHeader("user-agent"));
        request = new MonitorServletRequest(req, this.monitor.getConfig().getMaxBodySize());
        response = new MonitorServletResponse(resp);
        this.monitor.update();
        Throwable error = null;
        try {
            chain.doFilter(request, response);
        }
        catch (Throwable t) {
            error = t;
        }
        data = this.monitor.current();
        data.setBody(this.getBody((HttpServletRequest)((MonitorServletRequest)((Object)request))));
        data.setBodyContentLength(((MonitorServletRequest)((Object)request)).getBytesRead());
        data.setResponseContentType(response.getContentType());
        data.setResponseLength(((MonitorServletResponse)((Object)response)).getContentLength());
        data.setResponseStatus(((MonitorServletResponse)((Object)response)).getStatus());
        String cacheResult = ((MonitorServletResponse)((Object)response)).getHeader(GEOWEBCACHE_CACHE_RESULT);
        String missReason = ((MonitorServletResponse)((Object)response)).getHeader(GEOWEBCACHE_MISS_REASON);
        data.setCacheResult(cacheResult);
        data.setMissReason(missReason);
        if (error != null) {
            data.setStatus(RequestData.Status.FAILED);
            data.setErrorMessage(error.getLocalizedMessage());
            data.setError(error);
        }
        if (data.getStatus() != RequestData.Status.FAILED) {
            data.setStatus(RequestData.Status.FINISHED);
        }
        data.setEndTime(new Date());
        data.setTotalTime(data.getEndTime().getTime() - data.getStartTime().getTime());
        RenderTimeStatistics statistics = (RenderTimeStatistics)request.getAttribute("statistics");
        if (statistics != null) {
            ArrayList<Long> renderingTimeLayers = new ArrayList<Long>(statistics.getRenderingLayersIdxs().size());
            data.setLabellingProcessingTime(statistics.getLabellingTime());
            data.setResources(statistics.getLayerNames());
            for (Integer idx : statistics.getRenderingLayersIdxs()) {
                renderingTimeLayers.add(statistics.getRenderingTime(idx));
            }
            data.setResourcesProcessingTime(renderingTimeLayers);
            if (data.getEndTime() == null) {
                data.setEndTime(new Date());
            }
        }
        this.monitor.update();
        data = this.monitor.current();
        this.monitor.complete();
        PostProcessTask task = new PostProcessTask(this.monitor, data, req, resp, SecurityContextHolder.getContext().getAuthentication());
        task.setExecutionAudit(this.executionAudit);
        this.postProcessExecutor.execute(task);
        if (error != null) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new RuntimeException(error);
        }
    }

    public void destroy() {
        this.postProcessExecutor.shutdown();
        this.monitor.dispose();
    }

    String getRemoteAddr(HttpServletRequest req) {
        String forwardedFor = req.getHeader("X-Forwarded-For");
        if (forwardedFor != null) {
            String[] ips = forwardedFor.split(", ");
            return ips[0];
        }
        return req.getRemoteAddr();
    }

    String getHttpReferer(HttpServletRequest req) {
        String referer = req.getHeader("Referer");
        if (referer == null) {
            referer = req.getHeader("Referrer");
        }
        return referer;
    }

    byte[] getBody(HttpServletRequest req) {
        long maxBodyLength = this.monitor.config.getMaxBodySize();
        if (maxBodyLength == 0L) {
            return null;
        }
        try {
            byte[] body = ((MonitorServletRequest)req).getBodyContent();
            if (body != null && maxBodyLength != -1L && (long)body.length > maxBodyLength) {
                body = Arrays.copyOfRange(body, 0, (int)maxBodyLength);
            }
            return body;
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, "Could not read request body", ex);
            return null;
        }
    }

    void setExecutionAudit(BiConsumer<RequestData, Authentication> executionAudit) {
        this.executionAudit = executionAudit;
    }

    static class PostProcessTask
    implements Runnable {
        Monitor monitor;
        RequestData data;
        HttpServletRequest request;
        HttpServletResponse response;
        Authentication propagatedAuth;
        BiConsumer<RequestData, Authentication> executionAudit;

        PostProcessTask(Monitor monitor, RequestData data, HttpServletRequest request, HttpServletResponse response, Authentication propagatedAuth) {
            this.monitor = monitor;
            this.data = data;
            this.request = request;
            this.response = response;
            this.propagatedAuth = propagatedAuth;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SecurityContextHolder.getContext().setAuthentication(this.propagatedAuth);
                ArrayList<RequestPostProcessor> pp = new ArrayList<RequestPostProcessor>();
                pp.add(ReverseDNSPostProcessor.get(this.monitor.getConfig()));
                pp.addAll(GeoServerExtensions.extensions(RequestPostProcessor.class));
                Set<String> ignoreList = this.monitor.getConfig().getIgnorePostProcessors();
                for (RequestPostProcessor p : pp) {
                    try {
                        if (ignoreList.contains(p.getName())) continue;
                        p.run(this.data, this.request, this.response);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Post process task failed", e);
                    }
                }
                this.monitor.postProcessed(this.data);
            }
            finally {
                if (this.executionAudit != null) {
                    this.executionAudit.accept(this.data, SecurityContextHolder.getContext().getAuthentication());
                }
                this.monitor = null;
                this.data = null;
                this.request = null;
                this.response = null;
                SecurityContextHolder.getContext().setAuthentication(null);
            }
        }

        void setExecutionAudit(BiConsumer<RequestData, Authentication> executionAudit) {
            this.executionAudit = executionAudit;
        }
    }
}

