/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.ows.wms;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.monitor.MonitorConfig;
import org.geoserver.monitor.ows.RequestObjectHandler;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.wms.WMS;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class GetFeatureInfoHandler
extends RequestObjectHandler {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.monitor");

    public GetFeatureInfoHandler(MonitorConfig config) {
        super("org.geoserver.wms.GetFeatureInfoRequest", config);
    }

    @Override
    public List<String> getLayers(Object request) {
        List queryLayers = (List)OwsUtils.get((Object)request, (String)"queryLayers");
        if (queryLayers == null) {
            return null;
        }
        ArrayList<String> layers = new ArrayList<String>();
        for (Object queryLayer : queryLayers) {
            layers.add((String)OwsUtils.get(queryLayer, (String)"name"));
        }
        return layers;
    }

    @Override
    protected BoundingBox getBBox(Object request) {
        Object gmr = OwsUtils.get((Object)request, (String)"getMapRequest");
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)OwsUtils.get((Object)gmr, (String)"crs");
        Envelope mapEnv = (Envelope)OwsUtils.get((Object)gmr, (String)"bbox");
        ReferencedEnvelope mapBbox = new ReferencedEnvelope(mapEnv, crs);
        int x = (Integer)OwsUtils.get((Object)request, (String)"xPixel");
        int y = (Integer)OwsUtils.get((Object)request, (String)"yPixel");
        int width = (Integer)OwsUtils.get((Object)gmr, (String)"width");
        int height = (Integer)OwsUtils.get((Object)gmr, (String)"height");
        Coordinate coord = WMS.pixelToWorld((double)x, (double)y, (ReferencedEnvelope)mapBbox, (double)width, (double)height);
        try {
            return new ReferencedEnvelope(new Envelope(coord), crs).toBounds(this.monitorConfig.getBboxCrs());
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Could not transform bounding box to logging CRS", e);
            return null;
        }
    }
}

