/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.ows.wms;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.monitor.MonitorConfig;
import org.geoserver.monitor.ows.RequestObjectHandler;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;

public class GetMapHandler
extends RequestObjectHandler {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.monitor");

    public GetMapHandler(MonitorConfig config) {
        super("org.geoserver.wms.GetMapRequest", config);
    }

    @Override
    public List<String> getLayers(Object request) {
        List mapLayers = (List)OwsUtils.get((Object)request, (String)"layers");
        if (mapLayers == null) {
            return null;
        }
        ArrayList<String> layers = new ArrayList<String>();
        for (Object mapLayer : mapLayers) {
            layers.add((String)OwsUtils.get(mapLayer, (String)"name"));
        }
        return layers;
    }

    @Override
    protected BoundingBox getBBox(Object request) {
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)OwsUtils.get((Object)request, (String)"crs");
        Envelope env = (Envelope)OwsUtils.get((Object)request, (String)"bbox");
        if (env == null) {
            return null;
        }
        ReferencedEnvelope bbox = new ReferencedEnvelope(env, crs);
        try {
            return bbox.toBounds(this.monitorConfig.getBboxCrs());
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Could not transform bounding box to logging CRS", e);
            return null;
        }
    }
}

