/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.rest;

import java.io.IOException;
import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.RequestDataVisitor;
import org.geoserver.monitor.rest.BaseMonitorConverter;
import org.geoserver.monitor.rest.MonitorQueryResults;
import org.geoserver.monitor.rest.MonitorRequestController;
import org.geoserver.ows.util.OwsUtils;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;

@Component
public class ExcelMonitorConverter
extends BaseMonitorConverter {
    public ExcelMonitorConverter() {
        super(MonitorRequestController.EXCEL_MEDIATYPE);
    }

    protected void writeInternal(MonitorQueryResults results, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Object object = results.getResult();
        Monitor monitor = results.getMonitor();
        try (HSSFWorkbook wb = new HSSFWorkbook();){
            HSSFSheet sheet = wb.createSheet("requests");
            HSSFRow header = sheet.createRow(0);
            String[] fields = results.getFields();
            for (int i = 0; i < fields.length; ++i) {
                HSSFCell cell = header.createCell(i);
                cell.setCellValue((RichTextString)new HSSFRichTextString(fields[i]));
            }
            ExcelMonitorConverter.handleRequests(object, new ExcelRequestDataVisitor(sheet, fields), monitor);
            wb.write(outputMessage.getBody());
        }
    }

    private static final class ExcelRequestDataVisitor
    implements RequestDataVisitor {
        private final HSSFSheet sheet;
        int rowNumber = 1;
        private String[] fields;

        private ExcelRequestDataVisitor(HSSFSheet sheet, String[] fields) {
            this.sheet = sheet;
            this.fields = fields;
        }

        @Override
        public void visit(RequestData data, Object ... aggregates) {
            HSSFRow row = this.sheet.createRow(this.rowNumber++);
            for (int j = 0; j < this.fields.length; ++j) {
                HSSFCell cell = row.createCell(j);
                Object obj = OwsUtils.get((Object)data, (String)this.fields[j]);
                if (obj == null) continue;
                if (obj instanceof Date) {
                    cell.setCellValue((Date)obj);
                    continue;
                }
                if (obj instanceof Number) {
                    cell.setCellValue(((Number)obj).doubleValue());
                    continue;
                }
                cell.setCellValue((RichTextString)new HSSFRichTextString(obj.toString()));
            }
        }
    }
}

