/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.geoserver.monitor.MonitorServletRequest;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.DelegatingServletInputStream;
import org.springframework.mock.web.MockHttpServletRequest;

public class MonitorServletRequestTest {
    static final String THE_REQUEST = "TheRequest";

    @Test
    public void testInputStreamMaxSizeZero() throws Exception {
        byte[] data = MonitorServletRequestTest.data();
        DelegatingServletInputStream mock = new DelegatingServletInputStream((InputStream)new ByteArrayInputStream(data));
        try (MonitorServletRequest.MonitorInputStream in = new MonitorServletRequest.MonitorInputStream((ServletInputStream)mock, 0L);){
            byte[] read = MonitorServletRequestTest.read((InputStream)in);
            Assert.assertEquals((long)data.length, (long)read.length);
            byte[] buffer = in.getData();
            Assert.assertEquals((long)0L, (long)buffer.length);
            Assert.assertEquals((long)(data.length - 1), (long)in.getBytesRead());
        }
    }

    @Test
    public void testInputStream() throws Exception {
        byte[] data = MonitorServletRequestTest.data();
        DelegatingServletInputStream mock = new DelegatingServletInputStream((InputStream)new ByteArrayInputStream(data));
        try (MonitorServletRequest.MonitorInputStream in = new MonitorServletRequest.MonitorInputStream((ServletInputStream)mock, 1024L);){
            byte[] read = MonitorServletRequestTest.read((InputStream)in);
            Assert.assertEquals((long)data.length, (long)read.length);
            byte[] buffer = in.getData();
            Assert.assertEquals((long)1024L, (long)buffer.length);
            for (int i = 0; i < buffer.length; ++i) {
                Assert.assertEquals((long)data[i], (long)buffer[i]);
            }
            Assert.assertEquals((long)(data.length - 1), (long)in.getBytesRead());
        }
    }

    static byte[] data() throws IOException {
        try (InputStream in = MonitorServletRequest.class.getResourceAsStream("wms.xml");){
            byte[] byArray = MonitorServletRequestTest.read(in);
            return byArray;
        }
    }

    static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int n = 0;
        while ((n = in.read(buf)) > 0) {
            bytes.write(buf, 0, n);
        }
        in.close();
        return bytes.toByteArray();
    }

    @Test
    public void testGetReader() throws IOException {
        SingleInputCallRequest mock = new SingleInputCallRequest();
        MonitorServletRequest request = new MonitorServletRequest((HttpServletRequest)mock, 1024L);
        try (BufferedReader reader = request.getReader();){
            Assert.assertEquals((Object)THE_REQUEST, (Object)reader.readLine());
        }
        Assert.assertArrayEquals((byte[])THE_REQUEST.getBytes(), (byte[])request.getBodyContent());
    }

    @Test
    public void testGetInputStream() throws IOException {
        SingleInputCallRequest mock = new SingleInputCallRequest();
        MonitorServletRequest request = new MonitorServletRequest((HttpServletRequest)mock, 1024L);
        try (MonitorServletRequest.MonitorInputStream is = request.getInputStream();){
            Assert.assertEquals((Object)THE_REQUEST, (Object)IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
        }
        Assert.assertArrayEquals((byte[])THE_REQUEST.getBytes(), (byte[])request.getBodyContent());
    }

    @Test
    public void testNPEIsNotThrownWithBufferSizeUnbounded() throws Exception {
        byte[] data = MonitorServletRequestTest.data();
        DelegatingServletInputStream mock = new DelegatingServletInputStream((InputStream)new ByteArrayInputStream(data));
        try (MonitorServletRequest.MonitorInputStream in = new MonitorServletRequest.MonitorInputStream((ServletInputStream)mock, -1L);){
            byte[] read = MonitorServletRequestTest.read((InputStream)in);
            Assert.assertEquals((long)data.length, (long)read.length);
            byte[] buffer = in.getData();
            for (int i = 0; i < buffer.length; ++i) {
                Assert.assertEquals((long)data[i], (long)buffer[i]);
            }
            Assert.assertEquals((long)(data.length - 1), (long)in.getBytesRead());
        }
    }

    static final class SingleInputCallRequest
    extends MockHttpServletRequest {
        static final byte[] BUFFER = "TheRequest".getBytes();
        AtomicBoolean called = new AtomicBoolean(false);

        SingleInputCallRequest() {
        }

        public ServletInputStream getInputStream() {
            this.checkCalled();
            final ByteArrayInputStream bis = new ByteArrayInputStream(BUFFER);
            return new ServletInputStream(){

                public boolean isFinished() {
                    return bis.available() == 0;
                }

                public boolean isReady() {
                    return bis.available() > 0;
                }

                public void setReadListener(ReadListener readListener) {
                }

                public int read() throws IOException {
                    return bis.read();
                }
            };
        }

        public BufferedReader getReader() {
            this.checkCalled();
            return new BufferedReader(new InputStreamReader(new ByteArrayInputStream(BUFFER)));
        }

        private void checkCalled() {
            if (this.called.get()) {
                Assert.fail((String)"Input got retrieved twice");
            }
            this.called.set(true);
        }
    }
}

