/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.rest;

import java.text.ParseException;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.monitor.MemoryMonitorDAO;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.MonitorConfig;
import org.geoserver.monitor.MonitorDAO;
import org.geoserver.monitor.MonitorTestData;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.rest.RESTMonitorCallback;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.api.filter.Filter;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class RESTMonitorCallbackTest
extends GeoServerSystemTestSupport {
    static Monitor monitor;
    RESTMonitorCallback callback;
    RequestData data;
    static Catalog catalog;

    public static Filter parseFilter(String cql) {
        try {
            return CQL.toFilter((String)cql);
        }
        catch (CQLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @BeforeClass
    public static void setUpData() throws Exception {
        MemoryMonitorDAO dao = new MemoryMonitorDAO();
        new MonitorTestData((MonitorDAO)dao).setup();
        MonitorConfig mc = new MonitorConfig(){

            public MonitorDAO createDAO() {
                MemoryMonitorDAO dao = new MemoryMonitorDAO();
                try {
                    new MonitorTestData((MonitorDAO)dao).setup();
                    return dao;
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }

            public MonitorConfig.BboxMode getBboxMode() {
                return MonitorConfig.BboxMode.FULL;
            }
        };
        GeoServer gs = (GeoServer)EasyMock.createMock(GeoServer.class);
        monitor = new Monitor(mc);
        monitor.setServer(gs);
        catalog = new CatalogImpl();
        EasyMock.expect((Object)gs.getCatalog()).andStubReturn((Object)catalog);
        EasyMock.replay((Object[])new Object[]{gs});
        NamespaceInfo ns = catalog.getFactory().createNamespace();
        ns.setPrefix("acme");
        ns.setURI("http://acme.org");
        catalog.add(ns);
        DataStoreInfo ds = catalog.getFactory().createDataStore();
        FeatureTypeInfo ftFoo = catalog.getFactory().createFeatureType();
        ftFoo.setName("foo");
        ftFoo.setSRS("EPSG:4326");
        ftFoo.setNamespace(ns);
        ftFoo.setStore((StoreInfo)ds);
        catalog.add((ResourceInfo)ftFoo);
        FeatureTypeInfo ftBar = catalog.getFactory().createFeatureType();
        ftBar.setName("bar");
        ftBar.setSRS("EPSG:3348");
        ftBar.setNamespace(ns);
        ftBar.setStore((StoreInfo)ds);
        catalog.add((ResourceInfo)ftBar);
    }

    @Before
    public void setUp() throws Exception {
        this.callback = new RESTMonitorCallback(monitor);
        this.data = monitor.start();
    }

    @After
    public void tearDown() throws Exception {
        monitor.complete();
    }

    @Test
    public void testURLEncodedRequestPathInfo() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/layers/foo");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)"foo", this.data.getResources().get(1));
        response = this.getAsServletResponse("/rest/layers/acme:foo");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(2));
        response = this.getAsServletResponse("/restacme:foo");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Assert.assertEquals((Object)"acme:foo", this.data.getResources().get(3));
    }
}

