/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.util.ArrayList;
import java.util.List;
import org.geoserver.config.GeoServer;
import org.geoserver.monitor.MonitorConfig;
import org.geoserver.monitor.MonitorDAO;
import org.geoserver.monitor.Query;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.RequestDataListener;
import org.geoserver.monitor.RequestDataVisitor;
import org.geoserver.platform.GeoServerExtensions;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class Monitor
implements ApplicationListener<ApplicationEvent> {
    static ThreadLocal<RequestData> REQUEST = new ThreadLocal();
    static long PAGE_SIZE = 1000L;
    MonitorConfig config;
    MonitorDAO dao;
    GeoServer server;
    List<RequestDataListener> listeners = new ArrayList<RequestDataListener>();

    public Monitor(MonitorConfig config) {
        this.config = config;
        this.dao = config.createDAO();
    }

    public Monitor(MonitorDAO dao) {
        this.config = new MonitorConfig();
        this.dao = dao;
    }

    public MonitorConfig getConfig() {
        return this.config;
    }

    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    public RequestData start() {
        RequestData req = new RequestData();
        req = this.dao.init(req);
        REQUEST.set(req);
        for (RequestDataListener listener : this.listeners) {
            listener.requestUpdated(req);
        }
        if (this.config.getMode() != MonitorConfig.Mode.HISTORY) {
            this.dao.add(req);
        }
        return req;
    }

    public RequestData current() {
        return REQUEST.get();
    }

    public void update() {
        RequestData data = REQUEST.get();
        for (RequestDataListener listener : this.listeners) {
            listener.requestUpdated(data);
        }
        if (this.config.getMode() != MonitorConfig.Mode.HISTORY) {
            this.dao.update(data);
        }
    }

    public void complete() {
        RequestData data = REQUEST.get();
        for (RequestDataListener listener : this.listeners) {
            listener.requestCompleted(data);
        }
        this.dao.save(data);
        REQUEST.remove();
    }

    public void postProcessed(RequestData rd) {
        for (RequestDataListener listener : this.listeners) {
            listener.requestPostProcessed(rd);
        }
        this.dao.update(rd);
    }

    public void dispose() {
        this.dao.dispose();
        this.dao = null;
    }

    public MonitorDAO getDAO() {
        return this.dao;
    }

    public GeoServer getServer() {
        return this.server;
    }

    public void setServer(GeoServer server) {
        this.server = server;
    }

    public void query(Query q, RequestDataVisitor visitor) {
        this.dao.getRequests(q, visitor);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.listeners = GeoServerExtensions.extensions(RequestDataListener.class);
        }
    }
}

