/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;

public class PipeliningTaskQueue<K>
implements Runnable {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.monitor");
    volatile ConcurrentHashMap<K, Queue<Pipelineable<K>>> pipelines = new ConcurrentHashMap();
    ScheduledExecutorService executor;
    ExecutorService tasks = Executors.newCachedThreadPool();

    public void start() {
        this.executor = Executors.newScheduledThreadPool(4);
        this.executor.scheduleAtFixedRate(this, 0L, 10L, TimeUnit.MILLISECONDS);
        this.executor.scheduleAtFixedRate(this, 0L, 10L, TimeUnit.MILLISECONDS);
        this.executor.scheduleAtFixedRate(this, 0L, 10L, TimeUnit.MILLISECONDS);
        this.executor.scheduleAtFixedRate(this, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.executor.shutdown();
        this.executor = null;
        this.tasks.shutdown();
        this.tasks = null;
    }

    public void execute(K key, Runnable task) {
        this.execute(key, task, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(K key, Runnable task, String desc) {
        Queue<Pipelineable<K>> pipeline = this.pipelines.get(key);
        if (pipeline == null) {
            PipeliningTaskQueue pipeliningTaskQueue = this;
            synchronized (pipeliningTaskQueue) {
                Queue<Pipelineable<K>> other;
                pipeline = this.pipelines.get(key);
                if (pipeline == null && (other = this.pipelines.putIfAbsent(key, pipeline = new ConcurrentLinkedQueue<Pipelineable<K>>())) != null) {
                    pipeline = other;
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Queuing task into pipeline " + key);
        }
        pipeline.add(new Pipelineable<K>(key, task));
    }

    public void clear(K key) {
        this.pipelines.remove(key);
    }

    public void shutdown() {
        this.executor.shutdown();
        this.tasks.shutdown();
    }

    @Override
    public void run() {
        for (Queue<Pipelineable<K>> pipeline : this.pipelines.values()) {
            Pipelineable<K> job = pipeline.peek();
            if (job == null || !job.lock.tryLock()) continue;
            if (job.future != null) {
                if (job.future.isDone()) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Removing task from queue " + job.key);
                    }
                    pipeline.remove();
                }
            } else {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("Executing task in queue " + job.key);
                }
                job.future = this.tasks.submit(job.task);
            }
            job.lock.unlock();
        }
    }

    public class Pipelineable<K> {
        K key;
        Runnable task;
        Future<?> future;
        Lock lock;
        String desc;

        public Pipelineable(K key, Runnable task) {
            this.key = key;
            this.task = task;
            this.lock = new ReentrantLock();
        }
    }
}

