/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.auditlog;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.geoserver.platform.GeoServerResourceLoader;

public class AuditTemplateLoader
implements TemplateLoader {
    FileTemplateLoader fileTemplateLoader;
    ClassTemplateLoader classTemplateLoader;

    public AuditTemplateLoader(GeoServerResourceLoader rl) throws IOException {
        this.fileTemplateLoader = new FileTemplateLoader(rl.getBaseDirectory());
        this.classTemplateLoader = new ClassTemplateLoader(this.getClass(), "");
    }

    public void closeTemplateSource(Object source) throws IOException {
        if (source instanceof File) {
            this.fileTemplateLoader.closeTemplateSource(source);
        } else {
            ClassTemplateSource wrapper = (ClassTemplateSource)source;
            this.classTemplateLoader.closeTemplateSource(wrapper.source);
            wrapper.path = null;
            wrapper.source = null;
        }
    }

    public Object findTemplateSource(String path) throws IOException {
        Object result = this.fileTemplateLoader.findTemplateSource("monitoring/" + path);
        if (result != null) {
            return result;
        }
        Object source = this.classTemplateLoader.findTemplateSource(path);
        if (source != null) {
            return new ClassTemplateSource(path, source);
        }
        return null;
    }

    public Reader getReader(Object source, String encoding) throws IOException {
        if (source instanceof File) {
            return this.fileTemplateLoader.getReader(source, encoding);
        }
        ClassTemplateSource wrapper = (ClassTemplateSource)source;
        return this.classTemplateLoader.getReader(wrapper.source, encoding);
    }

    public long getLastModified(Object source) {
        if (source instanceof File) {
            return this.fileTemplateLoader.getLastModified(source);
        }
        ClassTemplateSource wrapper = (ClassTemplateSource)source;
        return this.classTemplateLoader.getLastModified(wrapper.source);
    }

    static class ClassTemplateSource {
        String path;
        Object source;

        public ClassTemplateSource(String path, Object source) {
            this.path = path;
            this.source = source;
        }
    }
}

