/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.ows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geoserver.catalog.Catalog;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.ows.RequestObjectHandler;
import org.geoserver.monitor.ows.wcs10.GetCoverageHandler;
import org.geoserver.monitor.ows.wcs11.DescribeCoverageHandler;
import org.geoserver.monitor.ows.wfs.DescribeFeatureTypeHandler;
import org.geoserver.monitor.ows.wfs.GetFeatureHandler;
import org.geoserver.monitor.ows.wfs.LockFeatureHandler;
import org.geoserver.monitor.ows.wfs.TransactionHandler;
import org.geoserver.monitor.ows.wfs20.GetFeature20Handler;
import org.geoserver.monitor.ows.wms.GetFeatureInfoHandler;
import org.geoserver.monitor.ows.wms.GetLegendGraphicHandler;
import org.geoserver.monitor.ows.wms.GetMapHandler;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;

public class MonitorCallback
implements DispatcherCallback {
    List<RequestObjectHandler> handlers = new ArrayList<RequestObjectHandler>();
    Monitor monitor;
    volatile Map<String, Map<String, String>> OPS;

    public MonitorCallback(Monitor monitor, Catalog catalog) {
        this.monitor = monitor;
        this.handlers.add(new DescribeFeatureTypeHandler(monitor.getConfig(), catalog));
        this.handlers.add(new GetFeatureHandler(monitor.getConfig(), catalog));
        this.handlers.add(new LockFeatureHandler(monitor.getConfig(), catalog));
        this.handlers.add(new TransactionHandler(monitor.getConfig(), catalog));
        this.handlers.add(new GetFeature20Handler(monitor.getConfig(), catalog));
        this.handlers.add(new GetFeatureInfoHandler(monitor.getConfig()));
        this.handlers.add(new GetMapHandler(monitor.getConfig()));
        this.handlers.add(new GetLegendGraphicHandler(monitor.getConfig()));
        this.handlers.add(new org.geoserver.monitor.ows.wcs10.DescribeCoverageHandler(monitor.getConfig()));
        this.handlers.add(new GetCoverageHandler(monitor.getConfig()));
        this.handlers.add(new DescribeCoverageHandler(monitor.getConfig()));
        this.handlers.add(new org.geoserver.monitor.ows.wcs11.GetCoverageHandler(monitor.getConfig()));
    }

    public Request init(Request request) {
        return null;
    }

    public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
        return null;
    }

    public Service serviceDispatched(Request request, Service service) throws ServiceException {
        return null;
    }

    public Operation operationDispatched(Request request, Operation operation) {
        RequestData data = this.monitor.current();
        if (data == null) {
            return operation;
        }
        data.setCategory(RequestData.Category.OWS);
        data.setService(operation.getService().getId().toUpperCase());
        data.setOperation(this.normalizedOpId(operation));
        data.setOwsVersion(operation.getService().getVersion().toString());
        if (operation.getParameters().length > 0) {
            Object reqObj = operation.getParameters()[0];
            for (RequestObjectHandler h : this.handlers) {
                if (!h.canHandle(reqObj)) continue;
                h.handle(reqObj, data);
                break;
            }
        }
        this.monitor.update();
        return operation;
    }

    public Object operationExecuted(Request request, Operation operation, Object result) {
        return null;
    }

    public void finished(Request request) {
        if (request.getError() != null) {
            RequestData data = this.monitor.current();
            if (data == null) {
                return;
            }
            data.setStatus(RequestData.Status.FAILED);
            data.setErrorMessage(request.getError().getLocalizedMessage());
            data.setError(request.getError());
            this.monitor.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String normalizedOpId(Operation op) {
        String normalized;
        Map<String, String> map;
        if (this.OPS == null) {
            MonitorCallback monitorCallback = this;
            synchronized (monitorCallback) {
                if (this.OPS == null) {
                    HashMap<String, Map<String, String>> tmp = new HashMap<String, Map<String, String>>();
                    for (Service s : GeoServerExtensions.extensions(Service.class)) {
                        HashMap<String, String> map2 = new HashMap<String, String>();
                        tmp.put(s.getId().toUpperCase(), map2);
                        for (String o : s.getOperations()) {
                            map2.put(o.toUpperCase(), o);
                        }
                    }
                    this.OPS = tmp;
                }
            }
        }
        if ((map = this.OPS.get(op.getService().getId().toUpperCase())) != null && (normalized = map.get(op.getId().toUpperCase())) != null) {
            return normalized;
        }
        return op.getId();
    }
}

