/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.ows;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.monitor.MonitorConfig;
import org.geoserver.monitor.RequestData;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.util.logging.Logging;

public abstract class RequestObjectHandler {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.monitor");
    String reqObjClassName;
    protected MonitorConfig monitorConfig;

    protected RequestObjectHandler(String reqObjClassName, MonitorConfig config) {
        this.reqObjClassName = reqObjClassName;
        this.monitorConfig = config;
    }

    public boolean canHandle(Object request) {
        Class<?> clazz;
        try {
            clazz = Class.forName(this.reqObjClassName);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return clazz.isInstance(request);
    }

    public void handle(Object request, RequestData data) {
        try {
            data.setResources(this.getLayers(request));
            if (this.monitorConfig.getBboxMode() != MonitorConfig.BboxMode.NONE) {
                data.setBbox(this.getBBox(request));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error handling request object", e);
        }
    }

    protected abstract List<String> getLayers(Object var1);

    protected BoundingBox getBBox(Object request) {
        return null;
    }
}

