/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.ows.wcs10;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.monitor.MonitorConfig;
import org.geoserver.monitor.ows.RequestObjectHandler;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.xsd.EMFUtils;

public class GetCoverageHandler
extends RequestObjectHandler {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.monitor");

    public GetCoverageHandler(MonitorConfig config) {
        super("net.opengis.wcs10.GetCoverageType", config);
    }

    @Override
    public List<String> getLayers(Object request) {
        String source = (String)EMFUtils.get((EObject)((EObject)request), (String)"sourceCoverage");
        return source != null ? Arrays.asList(source) : null;
    }

    @Override
    protected BoundingBox getBBox(Object request) {
        Object domainSubset = OwsUtils.get((Object)request, (String)"domainSubset");
        Object spatialSubset = OwsUtils.get((Object)domainSubset, (String)"spatialSubset");
        if (spatialSubset == null) {
            return null;
        }
        List envelopes = (List)OwsUtils.get((Object)spatialSubset, (String)"envelope");
        Bounds env = (Bounds)envelopes.get(0);
        BoundingBox result = null;
        try {
            result = new ReferencedEnvelope(env).toBounds(this.monitorConfig.getBboxCrs());
        }
        catch (TransformException e) {
            LOGGER.log(Level.WARNING, "Could not transform bounding box to logging CRS", e);
            return null;
        }
        return result;
    }
}

