/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.ows.wfs;

import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.monitor.MonitorConfig;
import org.geoserver.monitor.ows.RequestObjectHandler;
import org.geoserver.ows.util.OwsUtils;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.filter.visitor.ExtractBoundsFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;

public abstract class WFSRequestObjectHandler
extends RequestObjectHandler {
    static final Logger LOGGER = Logging.getLogger(WFSRequestObjectHandler.class);
    ExtractBoundsFilterVisitor visitor = new ExtractBoundsFilterVisitor(){

        public Object visit(BBOX filter, Object data) {
            BoundingBox bounds;
            if (data == null) {
                return null;
            }
            BoundingBox bbox = (BoundingBox)data;
            try {
                bounds = filter.getBounds();
                if (bounds.getCoordinateReferenceSystem() == null) {
                    bounds = ReferencedEnvelope.create((Bounds)bounds, (CoordinateReferenceSystem)bbox.getCoordinateReferenceSystem());
                }
                bounds.toBounds(WFSRequestObjectHandler.this.monitorConfig.getBboxCrs());
            }
            catch (TransformException ex) {
                return null;
            }
            bbox.include(bounds);
            return bbox;
        }
    };
    Catalog catalog;

    protected WFSRequestObjectHandler(String reqObjClassName, MonitorConfig config, Catalog catalog) {
        super(reqObjClassName, config);
        this.catalog = catalog;
    }

    protected String toString(Object name) {
        if (name instanceof QName) {
            QName qName = (QName)name;
            String prefix = qName.getPrefix();
            if (prefix == null || "".equals(prefix)) {
                prefix = qName.getNamespaceURI();
            }
            if (prefix == null || "".equals(prefix)) {
                prefix = null;
            }
            return prefix != null ? prefix + ":" + qName.getLocalPart() : qName.getLocalPart();
        }
        return name.toString();
    }

    protected CoordinateReferenceSystem crsFromTypeName(QName typeName) {
        FeatureTypeInfo featureType = this.catalog.getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
        return featureType.getCRS();
    }

    protected abstract List<Object> getElements(Object var1);

    protected Object unwrapElement(Object element) {
        return element;
    }

    protected CoordinateReferenceSystem getCrsFromElement(Object element) {
        if (OwsUtils.has((Object)element, (String)"typeName")) {
            return this.crsFromTypeName((QName)OwsUtils.get((Object)element, (String)"typeName"));
        }
        return null;
    }

    protected ReferencedEnvelope getBBoxFromElement(Object element) {
        return null;
    }

    @Override
    protected BoundingBox getBBox(Object request) {
        if (this.monitorConfig.getBboxMode() != MonitorConfig.BboxMode.FULL) {
            return null;
        }
        List<Object> elements = this.getElements(request);
        if (elements == null) {
            return null;
        }
        try {
            ReferencedEnvelope result = new ReferencedEnvelope(this.monitorConfig.getBboxCrs());
            for (Object e : elements) {
                ReferencedEnvelope bbox = this.getBBoxFromElement(e = this.unwrapElement(e));
                if (bbox == null) {
                    Filter f;
                    CoordinateReferenceSystem defaultCrs = this.getCrsFromElement(e);
                    if (defaultCrs == null) continue;
                    Filter filter = f = OwsUtils.has((Object)e, (String)"filter") ? (Filter)OwsUtils.get((Object)e, (String)"filter") : null;
                    if (f != null) {
                        ReferencedEnvelope startingBbox = new ReferencedEnvelope(defaultCrs);
                        bbox = (ReferencedEnvelope)f.accept((FilterVisitor)this.visitor, (Object)startingBbox);
                    }
                }
                if (bbox == null) continue;
                result.include(bbox.toBounds(this.monitorConfig.getBboxCrs()));
            }
            return result;
        }
        catch (TransformException ex) {
            LOGGER.warning("Could not Transform bounds to desired CRS");
            return null;
        }
    }
}

