/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.rest;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.Query;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.rest.BaseMonitorConverter;
import org.geoserver.monitor.rest.MonitorQueryResults;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.rest.ResourceNotFoundException;
import org.geoserver.rest.RestBaseController;
import org.geoserver.rest.RestException;
import org.geoserver.rest.wrapper.RestWrapper;
import org.geotools.util.Converters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/monitor/requests/{request}", "/rest/monitor/requests"})
public class MonitorRequestController
extends RestBaseController {
    static final String CSV_MEDIATYPE_VALUE = "application/csv";
    static final String ZIP_MEDIATYPE_VALUE = "application/zip";
    static final String EXCEL_MEDIATYPE_VALUE = "application/vnd.ms-excel";
    static final MediaType EXCEL_MEDIATYPE = MediaType.valueOf((String)"application/vnd.ms-excel");
    static final MediaType ZIP_MEDIATYPE = MediaType.valueOf((String)"application/zip");
    static final MediaType CSV_MEDIATYPE = MediaType.valueOf((String)"application/csv");
    Monitor monitor;

    @Autowired
    public MonitorRequestController(Monitor monitor) {
        this.monitor = monitor;
    }

    String[] getFields(String fields) {
        if (fields != null) {
            return fields.split(";");
        }
        List props = OwsUtils.getClassProperties(RequestData.class).properties();
        props.remove("Class");
        props.remove("Body");
        props.remove("Error");
        return props.toArray(new String[props.size()]);
    }

    @GetMapping(produces={"text/html", "application/xml", "application/json"})
    @ResponseBody
    protected RestWrapper handleObjectGetRestWrapper(@PathVariable(name="request", required=false) String req, @RequestParam(name="from", required=false) String from, @RequestParam(name="to", required=false) String to, @RequestParam(name="filter", required=false) String filter, @RequestParam(name="order", required=false) String order, @RequestParam(name="offset", required=false) Long offset, @RequestParam(name="count", required=false) Long count, @RequestParam(name="live", required=false) Boolean live, @RequestParam(name="fields", required=false) String fieldsSpec) throws Exception {
        MonitorQueryResults results = this.handleObjectGet(req, from, to, filter, order, offset, count, live, fieldsSpec);
        Object object = results.getResult();
        if (object instanceof RequestData) {
            return this.wrapObject((RequestData)object, RequestData.class);
        }
        ArrayList requests = new ArrayList();
        BaseMonitorConverter.handleRequests(object, (data, aggregates) -> requests.add(data), this.monitor);
        return this.wrapList(requests, RequestData.class);
    }

    protected String getTemplateName(Object o) {
        if (o instanceof RequestData) {
            return "request.html";
        }
        return "requests.html";
    }

    @GetMapping(produces={"application/csv", "application/vnd.ms-excel", "application/zip"})
    @ResponseBody
    protected MonitorQueryResults handleObjectGet(@PathVariable(name="request", required=false) String req, @RequestParam(name="from", required=false) String from, @RequestParam(name="to", required=false) String to, @RequestParam(name="filter", required=false) String filter, @RequestParam(name="order", required=false) String order, @RequestParam(name="offset", required=false) Long offset, @RequestParam(name="count", required=false) Long count, @RequestParam(name="live", required=false) Boolean live, @RequestParam(name="fields", required=false) String fieldsSpec) throws Exception {
        String[] fields = this.getFields(fieldsSpec);
        if (req == null) {
            Query q = new Query().between(from != null ? this.parseDate(from) : null, to != null ? this.parseDate(to) : null);
            if (filter != null) {
                try {
                    this.parseFilter(filter, q);
                }
                catch (Exception e) {
                    throw new RestException("Error parsing filter " + filter, HttpStatus.BAD_REQUEST, (Throwable)e);
                }
            }
            if (order != null) {
                Query.SortOrder sortOrder;
                String sortBy;
                int semi = order.indexOf(59);
                if (semi != -1) {
                    String[] split = order.split(";");
                    sortBy = split[0];
                    sortOrder = Query.SortOrder.valueOf(split[1]);
                } else {
                    sortBy = order;
                    sortOrder = Query.SortOrder.ASC;
                }
                q.sort(sortBy, sortOrder);
            }
            q.page(offset, count);
            if (live != null) {
                if (live.booleanValue()) {
                    q.filter("status", Arrays.asList(RequestData.Status.RUNNING, RequestData.Status.WAITING, RequestData.Status.CANCELLING), Query.Comparison.IN);
                } else {
                    q.filter("status", Arrays.asList(RequestData.Status.FINISHED, RequestData.Status.FAILED), Query.Comparison.IN);
                }
            }
            return new MonitorQueryResults(q, fields, this.monitor);
        }
        RequestData data = this.monitor.getDAO().getRequest(Long.parseLong(req));
        if (data == null) {
            throw new ResourceNotFoundException("No such request" + req);
        }
        return new MonitorQueryResults(data, fields, this.monitor);
    }

    Date parseDate(String s) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(s);
        }
        catch (ParseException e) {
            return (Date)Converters.convert((Object)s, Date.class);
        }
    }

    void parseFilter(String filter, Query q) {
        for (String s : filter.split(";")) {
            if ("".equals(s.trim())) continue;
            String[] split = s.split(":");
            String left = split[0];
            Object right = split[2];
            if (right.toString().contains(",")) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (String t : right.toString().split(",")) {
                    list.add(this.parseProperty(left, t));
                }
                right = list;
            } else {
                right = this.parseProperty(left, right.toString());
            }
            q.and(left, right, Query.Comparison.valueOf(split[1]));
        }
    }

    Object parseProperty(String property, String value) {
        if ("status".equals(property)) {
            return RequestData.Status.valueOf(value);
        }
        return value;
    }

    @DeleteMapping
    public void handleObjectDelete(@PathVariable(name="request", required=false) String req) {
        if (req != null) {
            throw new RestException("Cannot delete a specific request", HttpStatus.METHOD_NOT_ALLOWED);
        }
        this.monitor.getDAO().clear();
    }
}

