/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.web;

import java.util.HashMap;
import java.util.Map;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.Query;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.RequestDataVisitor;
import org.geoserver.monitor.web.OWSSummaryChartBasePanel;

public class OWSDetailsPanel
extends OWSSummaryChartBasePanel {
    private static final long serialVersionUID = 8958233133832178632L;

    public OWSDetailsPanel(String id, Monitor monitor, String owsService) {
        super(id, monitor, owsService);
    }

    @Override
    protected String getChartTitle() {
        return this.owsService + " Request Summary";
    }

    @Override
    protected Map<String, Integer> gatherData(Monitor monitor) {
        DataGatherer g = new DataGatherer();
        monitor.query(new Query().properties("operation").filter("service", this.owsService, Query.Comparison.EQ), g);
        return g.getData();
    }

    class DataGatherer
    implements RequestDataVisitor {
        HashMap<String, Integer> data = new HashMap();

        DataGatherer() {
        }

        @Override
        public void visit(RequestData req, Object ... aggregates) {
            String op = req.getOperation().toLowerCase();
            Integer count = this.data.get(op);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            this.data.put(op, count);
        }

        public HashMap<String, Integer> getData() {
            return this.data;
        }
    }
}

