/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.rest;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.json.JSONObject;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.MonitorTestData;
import org.geoserver.monitor.RequestData;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.geotools.feature.type.DateUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletResponse;

public class RequestControllerTest
extends GeoServerSystemTestSupport {
    private Monitor monitor;

    protected void setUpTestData(SystemTestData testData) throws Exception {
    }

    @Before
    public void setupMonitorContents() throws ParseException {
        this.monitor = (Monitor)applicationContext.getBean(Monitor.class);
        this.monitor.getDAO().dispose();
        new MonitorTestData(this.monitor.getDAO(), false).setup();
    }

    @Test
    public void testGetAllHTML() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/monitor/requests.html");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document document = Jsoup.parse((String)response.getContentAsString());
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/rest/monitor/requests/1.html", (Object)document.select("a:contains(1)").attr("href"));
        Assert.assertEquals((Object)"RUNNING", (Object)((Element)document.select("tr.even > td").get(1)).text());
    }

    @Test
    public void testGetHTMLById() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/monitor/requests/5.html");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Document document = Jsoup.parse((String)response.getContentAsString());
        Assert.assertEquals((Object)"Request 5", (Object)document.select("#content > h1 > span").text());
    }

    @Test
    public void testGetXMLById() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/monitor/requests/5.xml");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        org.w3c.dom.Document dom = this.dom(new ByteArrayInputStream(response.getContentAsByteArray()));
        XMLAssert.assertXpathEvaluatesTo((String)"5", (String)"/org.geoserver.monitor.RequestData/id", (org.w3c.dom.Document)dom);
        XMLAssert.assertXpathEvaluatesTo((String)"RUNNING", (String)"/org.geoserver.monitor.RequestData/status", (org.w3c.dom.Document)dom);
    }

    @Test
    public void testGetJSONById() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/monitor/requests/5.json");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        JSONObject json = (JSONObject)this.json(response);
        JSONObject data = json.getJSONObject("org.geoserver.monitor.RequestData");
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((Object)"5", (Object)data.getString("id"));
        Assert.assertEquals((Object)"RUNNING", (Object)data.getString("status"));
    }

    @Test
    public void testGetAllCSV() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/monitor/requests.csv?fields=id;path;startTime");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(response.getContentAsByteArray())));
        String line = in.readLine();
        Assert.assertEquals((Object)"id,path,startTime", (Object)line);
        Iterator it = this.monitor.getDAO().getRequests().iterator();
        while ((line = in.readLine()) != null) {
            Assert.assertTrue((boolean)it.hasNext());
            RequestData data = (RequestData)it.next();
            String expected = data.getId() + "," + data.getPath() + "," + DateUtil.serializeDateTime((Date)data.getStartTime());
            Assert.assertEquals((Object)expected, (Object)line);
        }
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testDelete() throws Exception {
        MockHttpServletResponse response = this.deleteAsServletResponse("/rest/monitor/requests");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((long)0L, (long)this.monitor.getDAO().getRequests().size());
    }

    @Test
    public void testGetAllExcel() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/monitor/requests.xls?fields=id;path;startTime");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        HSSFWorkbook wb = new HSSFWorkbook((InputStream)new ByteArrayInputStream(response.getContentAsByteArray()));
        HSSFSheet sheet = wb.getSheet("requests");
        Iterator rows = sheet.iterator();
        Iterator it = this.monitor.getDAO().getRequests().iterator();
        Assert.assertTrue((boolean)rows.hasNext());
        Row row = (Row)rows.next();
        Assert.assertEquals((Object)"id", (Object)row.getCell(0).getStringCellValue());
        Assert.assertEquals((Object)"path", (Object)row.getCell(1).getStringCellValue());
        Assert.assertEquals((Object)"startTime", (Object)row.getCell(2).getStringCellValue());
        while (rows.hasNext()) {
            row = (Row)rows.next();
            Assert.assertTrue((boolean)it.hasNext());
            RequestData data = (RequestData)it.next();
            Assert.assertEquals((double)data.getId(), (double)row.getCell(0).getNumericCellValue(), (double)0.1);
            Assert.assertEquals((Object)data.getPath(), (Object)row.getCell(1).getStringCellValue());
            Assert.assertEquals((Object)data.getStartTime(), (Object)row.getCell(2).getDateCellValue());
        }
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testGetZIP() throws Exception {
        Date startTime = new Date();
        Throwable throwable = new Throwable();
        RequestData data = new RequestData();
        data.setId(12345L);
        data.setPath("/foo");
        data.setStartTime(startTime);
        data.setBody("<foo></foo>".getBytes());
        data.setError(throwable);
        this.monitor.getDAO().dispose();
        this.monitor.getDAO().add(data);
        MockHttpServletResponse response = this.getAsServletResponse("/rest/monitor/requests/12345.zip?fields=id;path;startTime;Error;Body");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        ZipInputStream zin = new ZipInputStream(new ByteArrayInputStream(response.getContentAsByteArray()));
        ZipEntry entry = null;
        boolean requests = false;
        boolean body = false;
        boolean error = false;
        while ((entry = zin.getNextEntry()) != null) {
            if ("requests.csv".equals(entry.getName())) {
                requests = true;
                String expected = "id,path,startTime\n12345,/foo," + DateUtil.serializeDateTime((Date)startTime);
                Assert.assertEquals((Object)expected, (Object)this.readEntry(zin));
                continue;
            }
            if ("body.txt".equals(entry.getName())) {
                body = true;
                Assert.assertEquals((Object)"<foo></foo>", (Object)this.readEntry(zin));
                continue;
            }
            if (!"error.txt".equals(entry.getName())) continue;
            error = true;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            PrintStream stream = new PrintStream(bout);
            throwable.printStackTrace(stream);
            stream.flush();
            Assert.assertEquals((Object)new String(bout.toByteArray()).trim(), (Object)this.readEntry(zin));
        }
        Assert.assertTrue((boolean)requests);
        Assert.assertTrue((boolean)body);
        Assert.assertTrue((boolean)error);
    }

    String readEntry(ZipInputStream zin) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int n = -1;
        while ((n = zin.read(buf)) != -1) {
            out.write(buf, 0, n);
        }
        return new String(out.toByteArray()).trim();
    }

    @Test
    public void testGetDateRange() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/monitor/requests.csv?fields=id;path;startTime&from=2010-07-23T15:56:44&to=2010-07-23T16:16:44");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.assertCoveredInOrder(response, 6, 5, 4);
    }

    @Test
    public void testGetDateRangeWithTimeZone() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/monitor/requests.csv?fields=id;path;startTime&from=2010-07-23T15:56:44+0000&to=2010-07-23T16:16:44+0000");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.assertCoveredInOrder(response, 6, 5, 4);
    }

    @Test
    public void testFilter() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/monitor/requests.csv?fields=id;path;startTime&filter=path:EQ:/seven");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.assertCoveredInOrder(response, 7);
    }

    @Test
    public void testFilterIn() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/monitor/requests.csv?fields=id;path;startTime&filter=path:IN:/seven,/six,/five");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        RequestControllerTest.assertCovered(response, 5, 6, 7);
    }

    @Test
    public void testFilterStatus() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/monitor/requests.csv?fields=id;path;startTime&filter=status:EQ:WAITING");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        RequestControllerTest.assertCovered(response, 2, 6);
    }

    @Test
    public void testSorting() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/monitor/requests.csv?fields=id;path;startTime&order=path");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.assertCoveredInOrder(response, 8, 5, 4, 9, 1, 7, 6, 10, 3, 2);
        response = this.getAsServletResponse("/rest/monitor/requests.csv?fields=id;path;startTime&order=path;ASC");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.assertCoveredInOrder(response, 8, 5, 4, 9, 1, 7, 6, 10, 3, 2);
        response = this.getAsServletResponse("/rest/monitor/requests.csv?fields=id;path;startTime&order=path;DESC");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.assertCoveredInOrder(response, 2, 3, 10, 6, 7, 1, 9, 4, 5, 8);
    }

    @Test
    public void testPaging() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/monitor/requests.csv?fields=id;path;startTime&order=startTime&offset=5&count=2");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        this.assertCoveredInOrder(response, 6, 7);
    }

    @Test
    public void testLive() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("/rest/monitor/requests.csv?fields=id;path;startTime&live=yes");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        RequestControllerTest.assertCovered(response, 1, 2, 5, 6, 9, 10);
    }

    private void assertCoveredInOrder(MockHttpServletResponse response, int ... expectedIds) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(response.getContentAsByteArray())));
        String line = in.readLine();
        PrimitiveIterator.OfInt it = Arrays.stream(expectedIds).iterator();
        while ((line = in.readLine()) != null) {
            Assert.assertTrue((boolean)it.hasNext());
            Integer id = (Integer)it.next();
            MatcherAssert.assertThat((Object)line, (Matcher)Matchers.startsWith((String)("" + id)));
        }
        Assert.assertFalse((boolean)it.hasNext());
    }

    public static void assertCovered(MockHttpServletResponse response, int ... expectedIds) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(response.getContentAsByteArray())));
        String line = in.readLine();
        HashSet<Integer> actualIds = new HashSet<Integer>();
        while ((line = in.readLine()) != null) {
            String[] split = line.split("\\s*,\\s*");
            actualIds.add(Integer.parseInt(split[0]));
        }
        Assert.assertEquals((long)expectedIds.length, (long)actualIds.size());
        for (int expectedId : expectedIds) {
            MatcherAssert.assertThat(actualIds, (Matcher)CoreMatchers.hasItem((Object)expectedId));
        }
    }
}

