/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.geoserver.monitor.And;
import org.geoserver.monitor.Filter;
import org.geoserver.monitor.Or;

public class Query
implements Serializable {
    List<String> properties = new ArrayList<String>();
    String sortBy;
    SortOrder sortOrder;
    Date fromDate;
    Date toDate;
    Long offset;
    Long count;
    Filter filter;
    List<String> aggregates = new ArrayList<String>();
    List<String> groupBy = new ArrayList<String>();

    public Query properties(String ... props) {
        for (String p : props) {
            this.properties.add(p);
        }
        return this;
    }

    public Query sort(String property, SortOrder order) {
        this.sortBy = property;
        this.sortOrder = order;
        return this;
    }

    public Query filter(Object left, Object right, Comparison type) {
        return this.filter(new Filter(left, right, type));
    }

    public Query filter(Filter filter) {
        return this.and(filter);
    }

    public Query and(Object left, Object right, Comparison type) {
        return this.and(new Filter(left, right, type));
    }

    public Query and(Filter f) {
        if (this.filter == null) {
            this.filter = f;
        } else if (this.filter instanceof And) {
            ((And)this.filter).getFilters().add(f);
        } else {
            this.filter = new And(this.filter, f);
        }
        return this;
    }

    public Query or(Object left, Object right, Comparison type) {
        return this.or(new Filter(left, right, type));
    }

    public Query or(Filter f) {
        if (this.filter == null) {
            this.filter = f;
        } else if (this.filter instanceof Or) {
            ((Or)this.filter).getFilters().add(f);
        } else {
            this.filter = new Or(this.filter, f);
        }
        return this;
    }

    public Query between(Date from, Date to) {
        this.fromDate = from;
        this.toDate = to;
        return this;
    }

    public Query page(Long offset, Long count) {
        this.offset = offset;
        this.count = count;
        return this;
    }

    public Query aggregate(String ... aggregates) {
        this.aggregates.addAll(Arrays.asList(aggregates));
        return this;
    }

    public Query group(String ... properties) {
        this.groupBy.addAll(Arrays.asList(properties));
        return this;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public Long getOffset() {
        return this.offset;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public List<String> getAggregates() {
        return this.aggregates;
    }

    public List<String> getGroupBy() {
        return this.groupBy;
    }

    public Query clone() {
        Query clone = new Query();
        clone.properties.addAll(this.properties);
        clone.aggregates.addAll(this.aggregates);
        clone.groupBy.addAll(this.groupBy);
        clone.count = this.count;
        clone.offset = this.offset;
        clone.fromDate = this.fromDate;
        clone.toDate = this.toDate;
        clone.sortBy = this.sortBy;
        clone.sortOrder = this.sortOrder;
        clone.filter = this.filter;
        return clone;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    SELECT: ").append(this.properties).append("\n");
        sb.append(" AGGREGATE: ").append(this.aggregates).append("\n");
        sb.append("    FILTER: ").append(this.filter).append("\n");
        sb.append("   BETWEEN: ").append(this.fromDate).append(", ").append(this.toDate).append("\n");
        sb.append("    OFFSET: ").append(this.offset).append(" LIMIT:").append(this.count).append("\n");
        sb.append("   SORT BY: ").append(this.sortBy).append(", ").append((Object)this.sortOrder).append("\n");
        sb.append("  GROUP BY: ").append(this.groupBy);
        return sb.toString();
    }

    public static enum Comparison {
        EQ{

            public String toString() {
                return "=";
            }
        }
        ,
        NEQ{

            public String toString() {
                return "!=";
            }
        }
        ,
        LT{

            public String toString() {
                return "<";
            }
        }
        ,
        LTE{

            public String toString() {
                return "<=";
            }
        }
        ,
        GT{

            public String toString() {
                return ">";
            }
        }
        ,
        GTE{

            public String toString() {
                return ">=";
            }
        }
        ,
        IN{

            public String toString() {
                return "IN";
            }
        };

    }

    public static enum SortOrder {
        ASC,
        DESC;

    }
}

