/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.ows;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.RequestData;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.util.OwsUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class ControlFlowCallbackProxy
implements InvocationHandler,
BeanPostProcessor {
    Object target;
    Monitor monitor;

    public ControlFlowCallbackProxy(Monitor monitor) {
        this.monitor = monitor;
    }

    public ControlFlowCallbackProxy(Monitor monitor, Object target) {
        this.monitor = monitor;
        this.target = target;
    }

    public long getRunningRequests() {
        return (Long)OwsUtils.get((Object)this.target, (String)"runningRequests");
    }

    public long getBlockedRequests() {
        return (Long)OwsUtils.get((Object)this.target, (String)"blockedRequests");
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if ("ControlFlowCallback".equals(bean.getClass().getSimpleName())) {
            bean = Proxy.newProxyInstance(bean.getClass().getClassLoader(), new Class[]{DispatcherCallback.class}, (InvocationHandler)new ControlFlowCallbackProxy(this.monitor, bean));
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("operationDispatched".equals(method.getName()) && this.monitor.current() != null) {
            RequestData data = this.monitor.current();
            if (data == null) {
                return method.invoke(this.target, args);
            }
            data.setStatus(RequestData.Status.WAITING);
            this.monitor.update();
            Object result = method.invoke(this.target, args);
            data.setStatus(RequestData.Status.RUNNING);
            this.monitor.update();
            return result;
        }
        return method.invoke(this.target, args);
    }
}

