/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.rest;

import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.rest.MonitorQueryResults;
import org.geoserver.monitor.rest.MonitorRequestController;
import org.geoserver.rest.wrapper.RestWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/rest/monitor/requests/ows/{request}"})
public class OwsRequestResource
extends MonitorRequestController {
    @Autowired
    public OwsRequestResource(Monitor monitor) {
        super(monitor);
    }

    @Override
    @GetMapping(produces={"application/csv", "application/vnd.ms-excel", "application/zip"})
    @ResponseBody
    protected RestWrapper handleObjectGetRestWrapper(@PathVariable(name="request", required=false) String req, @RequestParam(name="from", required=false) String from, @RequestParam(name="to", required=false) String to, @RequestParam(name="filter", required=false) String filter, @RequestParam(name="order", required=false) String order, @RequestParam(name="offset", required=false) Long offset, @RequestParam(name="count", required=false) Long count, @RequestParam(name="live", required=false) Boolean live, @RequestParam(name="fields", required=false) String fieldsSpec) throws Exception {
        return super.handleObjectGetRestWrapper(req, from, to, filter, order, offset, count, live, fieldsSpec);
    }

    @Override
    @GetMapping(produces={"text/html", "application/csv", "application/vnd.ms-excel", "application/zip"})
    @ResponseBody
    protected MonitorQueryResults handleObjectGet(@PathVariable(name="request", required=false) String req, @RequestParam(name="from", required=false) String from, @RequestParam(name="to", required=false) String to, @RequestParam(name="filter", required=false) String filter, @RequestParam(name="order", required=false) String order, @RequestParam(name="offset", required=false) Long offset, @RequestParam(name="count", required=false) Long count, @RequestParam(name="live", required=false) Boolean live, @RequestParam(name="fields", required=false) String fieldsSpec) throws Exception {
        if (req == null) {
            String[] fields = this.getFields(fieldsSpec);
            return new MonitorQueryResults(this.monitor.getDAO().getOwsRequests(), fields, this.monitor);
        }
        return this.handleObjectGet(req, from, to, filter, order, offset, count, live, fieldsSpec);
    }
}

