/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.monitor.web;

import java.awt.Color;
import java.awt.Paint;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.image.NonCachingImage;
import org.apache.wicket.markup.html.image.resource.BufferedDynamicImageResource;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.resource.IResource;
import org.geoserver.monitor.Monitor;
import org.geoserver.monitor.Query;
import org.geoserver.monitor.RequestData;
import org.geoserver.monitor.RequestDataVisitor;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.DateField;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.xy.XYDataset;

public abstract class ActivityChartBasePanel
extends Panel {
    private static final long serialVersionUID = -2436197080363116473L;
    Date from;
    Date to;
    NonCachingImage chartImage;

    public ActivityChartBasePanel(String id, Monitor monitor) {
        super(id);
        Date[] range = this.getDateRange();
        BufferedDynamicImageResource resource = this.queryAndRenderChart(monitor, range);
        Component[] componentArray = new Component[1];
        this.chartImage = new NonCachingImage("chart", (IResource)resource);
        componentArray[0] = this.chartImage;
        this.add(componentArray);
        this.chartImage.setOutputMarkupId(true);
        Form form = new Form("form");
        this.add(new Component[]{form});
        this.from = new Date(range[0].getTime());
        this.to = new Date(range[1].getTime());
        form.add(new Component[]{new DateField("from", (IModel)new PropertyModel((Object)this, "from"), true)});
        form.add(new Component[]{new DateField("to", (IModel)new PropertyModel((Object)this, "to"), true)});
        form.add(new Component[]{new AjaxButton("refresh"){
            private static final long serialVersionUID = -6954067333262732996L;

            protected void onSubmit(AjaxRequestTarget target) {
                Monitor monitor = (Monitor)((GeoServerApplication)this.getApplication()).getBeanOfType(Monitor.class);
                Date[] range = new Date[]{ActivityChartBasePanel.this.from, ActivityChartBasePanel.this.to};
                ActivityChartBasePanel.this.chartImage.setImageResource((IResource)ActivityChartBasePanel.this.queryAndRenderChart(monitor, range));
                target.add(new Component[]{ActivityChartBasePanel.this.chartImage});
            }
        }});
    }

    BufferedDynamicImageResource queryAndRenderChart(Monitor monitor, Date[] range) {
        Query q = new Query();
        q.properties("startTime").between(range[0], range[1]);
        DataGatherer gatherer = new DataGatherer();
        monitor.query(q, gatherer);
        HashMap<RegularTimePeriod, Integer> data = gatherer.getData();
        Class<?> timeUnitClass = this.getTimePeriod(range[0]).getClass();
        TimeSeries series = new TimeSeries((Comparable)((Object)"foo"), timeUnitClass);
        for (Map.Entry<RegularTimePeriod, Integer> d : data.entrySet()) {
            series.add(new TimeSeriesDataItem(d.getKey(), (Number)d.getValue()));
        }
        TimeSeriesCollection dataset = new TimeSeriesCollection(series);
        JFreeChart chart = this.createTimeSeriesChart(this.getChartTitle(range), "Time (" + timeUnitClass.getSimpleName() + ")", "Requests", (XYDataset)dataset);
        BufferedDynamicImageResource resource = new BufferedDynamicImageResource();
        resource.setImage(chart.createBufferedImage(700, 500));
        return resource;
    }

    JFreeChart createTimeSeriesChart(String title, String timeAxisLabel, String valueAxisLabel, XYDataset dataset) {
        DateAxis timeAxis = new DateAxis(timeAxisLabel);
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        valueAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, null);
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        plot.setRenderer((XYItemRenderer)renderer);
        JFreeChart chart = new JFreeChart((Plot)plot);
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setAntiAlias(true);
        chart.clearSubtitles();
        return chart;
    }

    protected String getChartTitle(Date[] range) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return "Activity " + format.format(range[0]) + " - " + format.format(range[1]);
    }

    protected abstract Date[] getDateRange();

    protected abstract RegularTimePeriod getTimePeriod(Date var1);

    class DataGatherer
    implements RequestDataVisitor {
        HashMap<RegularTimePeriod, Integer> data = new HashMap();

        DataGatherer() {
        }

        @Override
        public void visit(RequestData r, Object ... aggregates) {
            RegularTimePeriod period = ActivityChartBasePanel.this.getTimePeriod(r.getStartTime());
            Integer count = this.data.get(period);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            this.data.put(period, count);
        }

        public HashMap<RegularTimePeriod, Integer> getData() {
            return this.data;
        }
    }
}

