/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIBodyMethodProcessor;
import org.geoserver.ogcapi.APIConfigurationSupport;
import org.geoserver.ogcapi.APIContentNegotiationManager;
import org.geoserver.ogcapi.APIExceptionHandler;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.AnnotatedHTMLMessageConverter;
import org.geoserver.ogcapi.DocumentCallback;
import org.geoserver.ogcapi.LocalWorkspaceURLPathHelper;
import org.geoserver.ogcapi.MappingJackson2HttpMessageConverter;
import org.geoserver.ogcapi.MappingJackson2YAMLMessageConverter;
import org.geoserver.ogcapi.OpenAPICallback;
import org.geoserver.ogcapi.ResourceNotFoundException;
import org.geoserver.ogcapi.ReturnValueMethodParameter;
import org.geoserver.ows.ClientStreamAbortedException;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.DispatcherCallback;
import org.geoserver.ows.HttpErrorCodeException;
import org.geoserver.ows.LocalWorkspace;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.KvpMap;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geotools.util.Version;
import org.geotools.util.logging.Logging;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;
import org.springframework.validation.Validator;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.HandlerMethodReturnValueHandlerComposite;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.DispatcherServletWebRequest;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.UrlPathHelper;
import org.xml.sax.SAXException;

public class APIDispatcher
extends AbstractController {
    private static final String VERSION_HEADER = "API-Version";
    static final String RESPONSE_OBJECT = "ResponseObject";
    public static final String ROOT_PATH = "ogc";
    static final Logger LOGGER = Logging.getLogger((String)"org.geoserver.ogcapi");
    public static final String SERVICE_DISABLED_PREFIX = "Service ";
    public static final String SERVICE_DISABLED_SUFFIX = " is disabled";
    protected List<DispatcherCallback> callbacks = Collections.emptyList();
    private List<DocumentCallback> documentCallbacks;
    private List<OpenAPICallback> apiCallbacks;
    protected RequestMappingHandlerMapping mappingHandler;
    protected RequestMappingHandlerAdapter handlerAdapter;
    protected HandlerMethodReturnValueHandlerComposite returnValueHandlers;
    protected ContentNegotiationManager contentNegotiationManager = new APIContentNegotiationManager();
    private List<HttpMessageConverter<?>> messageConverters;
    private List<APIExceptionHandler> exceptionHandlers;
    private final GeoServer geoServer;

    public APIDispatcher(GeoServer geoServer) {
        super(false);
        this.geoServer = geoServer;
    }

    protected void initApplicationContext(ApplicationContext context) {
        this.callbacks = GeoServerExtensions.extensions(DispatcherCallback.class, (ApplicationContext)context);
        this.exceptionHandlers = GeoServerExtensions.extensions(APIExceptionHandler.class, (ApplicationContext)context);
        this.documentCallbacks = GeoServerExtensions.extensions(DocumentCallback.class, (ApplicationContext)context);
        this.apiCallbacks = GeoServerExtensions.extensions(OpenAPICallback.class, (ApplicationContext)context);
        this.mappingHandler = new APIRequestHandlerMapping();
        this.mappingHandler.setApplicationContext(context);
        this.mappingHandler.afterPropertiesSet();
        APIConfigurationSupport configurationSupport = (APIConfigurationSupport)((Object)context.getBean(APIConfigurationSupport.class));
        configurationSupport.setCallbacks(this.callbacks);
        this.handlerAdapter = configurationSupport.requestMappingHandlerAdapter((ContentNegotiationManager)context.getBean("mvcContentNegotiationManager", ContentNegotiationManager.class), (FormattingConversionService)context.getBean("mvcConversionService", FormattingConversionService.class), (Validator)context.getBean("mvcValidator", Validator.class));
        this.handlerAdapter.setApplicationContext(context);
        this.handlerAdapter.afterPropertiesSet();
        this.handlerAdapter.getMessageConverters().removeIf(AbstractJackson2HttpMessageConverter.class::isInstance);
        this.handlerAdapter.getMessageConverters().add(0, new MappingJackson2YAMLMessageConverter());
        this.handlerAdapter.getMessageConverters().add(0, new MappingJackson2HttpMessageConverter());
        List extensionConverters = GeoServerExtensions.extensions(HttpMessageConverter.class);
        this.addToListBackwards(extensionConverters, this.handlerAdapter.getMessageConverters());
        this.messageConverters = this.handlerAdapter.getMessageConverters();
        List pluginResolvers = GeoServerExtensions.extensions(HandlerMethodArgumentResolver.class);
        ArrayList adapterResolvers = new ArrayList();
        List existingResolvers = this.handlerAdapter.getArgumentResolvers();
        if (existingResolvers != null) {
            adapterResolvers.addAll(existingResolvers);
        }
        this.addToListBackwards(pluginResolvers, adapterResolvers);
        this.handlerAdapter.setArgumentResolvers(adapterResolvers);
        List returnValueHandlers = Optional.ofNullable(this.handlerAdapter.getReturnValueHandlers()).orElse(Collections.emptyList()).stream().map(this::replaceBodyMethodProcessor).collect(Collectors.toList());
        this.returnValueHandlers = new HandlerMethodReturnValueHandlerComposite();
        this.returnValueHandlers.addHandlers(returnValueHandlers);
        this.handlerAdapter.setReturnValueHandlers(Arrays.asList(new HandlerMethodReturnValueHandler(){

            public boolean supportsReturnType(MethodParameter returnType) {
                return true;
            }

            public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
                mavContainer.getModel().put((Object)APIDispatcher.RESPONSE_OBJECT, returnValue);
            }
        }));
    }

    private HandlerMethodReturnValueHandler replaceBodyMethodProcessor(HandlerMethodReturnValueHandler f) {
        if (f instanceof RequestResponseBodyMethodProcessor) {
            return new APIBodyMethodProcessor(this.handlerAdapter.getMessageConverters(), this.contentNegotiationManager, this.callbacks);
        }
        return f;
    }

    private void addToListBackwards(List source, List target) {
        ListIterator arIterator = source.listIterator(source.size());
        while (arIterator.hasPrevious()) {
            target.add(0, arIterator.previous());
        }
    }

    protected void preprocessRequest(HttpServletRequest request) throws Exception {
        Charset charSet = null;
        charSet = StandardCharsets.UTF_8;
        if (request.getCharacterEncoding() != null) {
            try {
                charSet = Charset.forName(request.getCharacterEncoding());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        request.setCharacterEncoding(charSet.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        this.preprocessRequest(httpRequest);
        Request dr = new Request();
        Dispatcher.REQUEST.set(dr);
        dr.setHttpRequest(httpRequest);
        dr.setHttpResponse(httpResponse);
        dr.setGet("GET".equalsIgnoreCase(httpRequest.getMethod()));
        APIRequestInfo requestInfo = new APIRequestInfo(httpRequest, httpResponse, this);
        APIRequestInfo.set(requestInfo);
        try {
            Object returnValue;
            dr = this.init(dr);
            requestInfo.setRequestedMediaTypes(this.contentNegotiationManager.resolveMediaTypes((NativeWebRequest)new ServletWebRequest(dr.getHttpRequest())));
            HandlerMethod handler = this.getHandlerMethod(httpRequest, dr);
            this.dispatchService(dr, handler);
            ModelAndView mav = this.handlerAdapter.handle(dr.getHttpRequest(), dr.getHttpResponse(), (Object)handler);
            ModelAndViewContainer mavContainer = new ModelAndViewContainer();
            mavContainer.addAllAttributes(RequestContextUtils.getInputFlashMap((HttpServletRequest)dr.getHttpRequest()));
            Object object = returnValue = mav != null ? (Object)mav.getModel().get(RESPONSE_OBJECT) : null;
            if (returnValue instanceof AbstractDocument) {
                this.applyDocumentCallbacks(dr, (AbstractDocument)returnValue);
            } else if (returnValue instanceof OpenAPI) {
                this.applyOpenAPICallbacks(dr, (OpenAPI)returnValue);
            }
            returnValue = this.fireOperationExecutedCallback(dr, dr.getOperation(), returnValue);
            APIRequestInfo.get().setResult(returnValue);
            AnnotatedHTMLMessageConverter.processAnnotation(handler);
            this.addServiceVersionHeader(handler, httpResponse);
            this.returnValueHandlers.handleReturnValue(returnValue, (MethodParameter)new ReturnValueMethodParameter(handler.getMethod(), returnValue), mavContainer, (NativeWebRequest)new DispatcherServletWebRequest(dr.getHttpRequest(), dr.getHttpResponse()));
        }
        catch (Throwable t) {
            if (APIDispatcher.isSecurityException(t)) {
                throw (Exception)t;
            }
            this.exception(t, requestInfo);
        }
        finally {
            this.fireFinishedCallback(dr);
            Dispatcher.REQUEST.remove();
        }
        return null;
    }

    private void addServiceVersionHeader(HandlerMethod handler, HttpServletResponse httpResponse) {
        Class<?> serviceClass = handler.getBean().getClass();
        APIService apiService = APIDispatcher.getApiServiceAnnotation(serviceClass);
        if (apiService != null && apiService.version() != null) {
            httpResponse.addHeader(VERSION_HEADER, apiService.version());
        } else {
            this.logger.debug((Object)("Could not find the APIService annotation in the controller for:" + serviceClass));
        }
    }

    private void dispatchService(Request dr, HandlerMethod handler) {
        APIService annotation = APIDispatcher.getApiServiceAnnotation(handler.getBeanType());
        dr.setService(annotation.service());
        dr.setVersion(annotation.version());
        dr.setRequest(APIDispatcher.getOperationName(handler.getMethod()));
        Service service = new Service(annotation.service(), handler.getBean(), new Version(annotation.service()), Collections.emptyList());
        dr.setServiceDescriptor(service);
        service = this.fireServiceDispatchedCallback(dr, service);
        dr.setServiceDescriptor(service);
    }

    public static APIService getApiServiceAnnotation(Class<?> clazz) {
        APIService annotation = null;
        while (annotation == null && clazz != null) {
            annotation = clazz.getAnnotation(APIService.class);
            if (annotation != null) continue;
            clazz = clazz.getSuperclass();
        }
        return annotation;
    }

    private HandlerMethod getHandlerMethod(HttpServletRequest httpRequest, Request dr) throws Exception {
        LocalWorkspace.get();
        HandlerExecutionChain chain = this.mappingHandler.getHandler(dr.getHttpRequest());
        if (chain == null) {
            String msg = "No mapping for " + httpRequest.getMethod() + " " + APIDispatcher.getRequestUri(httpRequest);
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(msg);
            }
            throw new ResourceNotFoundException(msg);
        }
        Object handler = chain.getHandler();
        if (!this.handlerAdapter.supports(handler)) {
            String msg = "Mapping for " + httpRequest.getMethod() + " " + APIDispatcher.getRequestUri(httpRequest) + " found but it's not supported by the HandlerAdapter. Check for mis-setup of service beans";
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(msg);
            }
            throw new ResourceNotFoundException(msg);
        }
        return (HandlerMethod)handler;
    }

    private void exception(Throwable t, APIRequestInfo request) throws IOException {
        HttpServletResponse response = request.getResponse();
        Throwable current = t;
        while (!(current == null || current instanceof ClientStreamAbortedException || APIDispatcher.isSecurityException(current) || current instanceof HttpErrorCodeException)) {
            if (current instanceof SAXException) {
                current = ((SAXException)current).getException();
                continue;
            }
            current = current.getCause();
        }
        if (current instanceof ClientStreamAbortedException) {
            LOGGER.log(Level.FINER, "Client has closed stream", t);
            return;
        }
        if (APIDispatcher.isSecurityException(current)) {
            throw (RuntimeException)current;
        }
        LOGGER.log(Level.SEVERE, "Failed to dispatch API request", t);
        if (current instanceof HttpErrorCodeException) {
            HttpErrorCodeException hec = (HttpErrorCodeException)current;
            response.setContentType(hec.getContentType() != null ? hec.getContentType() : "text/plain");
            if (hec.getErrorCode() >= 400) {
                response.sendError(hec.getErrorCode(), hec.getMessage());
            } else {
                response.setStatus(hec.getErrorCode());
                response.getOutputStream().print(hec.getMessage());
            }
        } else if (t instanceof ServiceException && ((ServiceException)t).getCode() != null && ((ServiceException)t).getCode().equals("ServiceUnavailable")) {
            if (request.getService() != null && request.getService().getId() != null) {
                response.sendError(404, SERVICE_DISABLED_PREFIX + request.getService().getId() + SERVICE_DISABLED_SUFFIX);
            } else {
                response.sendError(404, t.getMessage());
            }
        } else {
            APIExceptionHandler handler = this.getExceptionHandler(t, request);
            if (handler == null) {
                response.sendError(500, t.getMessage());
            } else {
                handler.handle(t, response);
            }
        }
    }

    private APIExceptionHandler getExceptionHandler(Throwable t, APIRequestInfo request) {
        return this.exceptionHandlers.stream().filter(h -> h.canHandle(t, request)).findFirst().orElse(null);
    }

    Request init(Request request) throws ServiceException, IOException {
        String ctxPath = request.getHttpRequest().getContextPath();
        String reqPath = request.getHttpRequest().getRequestURI();
        if ((reqPath = reqPath.substring(ctxPath.length())).startsWith("/")) {
            reqPath = reqPath.substring(1, reqPath.length());
        }
        if (reqPath.endsWith("/")) {
            reqPath = reqPath.substring(0, reqPath.length() - 1);
        }
        String context = reqPath;
        String path = null;
        int index = context.lastIndexOf(47);
        if (index != -1) {
            path = context.substring(index + 1);
            context = context.substring(0, index);
        } else {
            path = reqPath;
            context = null;
        }
        request.setContext(context);
        request.setPath(path);
        Map kvp = request.getHttpRequest().getParameterMap();
        if (kvp == null || kvp.isEmpty()) {
            request.setKvp(new HashMap());
            request.setRawKvp(new HashMap());
        } else {
            KvpMap parsedKvp = KvpUtils.normalize((Map)kvp);
            KvpMap rawKvp = new KvpMap((Map)parsedKvp);
            request.setKvp((Map)parsedKvp);
            request.setRawKvp((Map)rawKvp);
        }
        return this.fireInitCallback(request);
    }

    Request fireInitCallback(Request req) {
        for (DispatcherCallback cb : this.callbacks) {
            Request r = cb.init(req);
            req = r != null ? r : req;
        }
        return req;
    }

    void fireFinishedCallback(Request req) {
        for (DispatcherCallback cb : this.callbacks) {
            try {
                cb.finished(req);
            }
            catch (Throwable t) {
                LOGGER.log(Level.WARNING, "Error firing finished callback for " + cb.getClass(), t);
            }
        }
    }

    protected static boolean isSecurityException(Throwable t) {
        return t != null && t.getClass().getPackage().getName().startsWith("org.springframework.security");
    }

    Service fireServiceDispatchedCallback(Request req, Service service) {
        for (DispatcherCallback cb : this.callbacks) {
            Service s = cb.serviceDispatched(req, service);
            service = s != null ? s : service;
        }
        return service;
    }

    Object fireOperationExecutedCallback(Request req, Operation op, Object result) {
        for (DispatcherCallback cb : this.callbacks) {
            Object r = cb.operationExecuted(req, op, result);
            result = r != null ? r : result;
        }
        return result;
    }

    private static String getRequestUri(HttpServletRequest request) {
        String uri = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (uri == null) {
            uri = request.getRequestURI();
        }
        return uri;
    }

    public List<HttpMessageConverter<?>> getConverters() {
        return Collections.unmodifiableList(this.messageConverters);
    }

    public List<MediaType> getProducibleMediaTypes(Class<?> responseType, boolean addHTML) {
        ArrayList<MediaType> result = new ArrayList<MediaType>();
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            if (converter instanceof GenericHttpMessageConverter) {
                if (!((GenericHttpMessageConverter)converter).canWrite(responseType, responseType, null)) continue;
                result.addAll(converter.getSupportedMediaTypes());
                continue;
            }
            if (!converter.canWrite(responseType, null)) continue;
            result.addAll(converter.getSupportedMediaTypes());
        }
        if (addHTML) {
            result.add(MediaType.TEXT_HTML);
        }
        return result.stream().filter(mt -> mt.isConcrete()).distinct().collect(Collectors.toList());
    }

    public static String getOperationName(Method m) {
        return Arrays.stream(m.getAnnotations()).filter(a -> APIDispatcher.isRequestMapping(a)).map(a -> {
            try {
                return (String)a.annotationType().getMethod("name", new Class[0]).invoke(a, new Object[0]);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to get name from request mapping annotation, unexpected", e);
                return "";
            }
        }).filter(name -> name != null && !name.isEmpty()).findFirst().orElse(m.getName());
    }

    public static boolean hasRequestMapping(Method m) {
        return Arrays.stream(m.getAnnotations()).anyMatch(a -> APIDispatcher.isRequestMapping(a));
    }

    private static boolean isRequestMapping(Annotation a) {
        return a instanceof RequestMapping || a.annotationType().getAnnotation(RequestMapping.class) != null;
    }

    private void applyDocumentCallbacks(Request dr, AbstractDocument document) {
        for (DocumentCallback callback : this.documentCallbacks) {
            callback.apply(dr, document);
        }
    }

    private void applyOpenAPICallbacks(Request dr, OpenAPI api) throws IOException {
        for (OpenAPICallback callback : this.apiCallbacks) {
            callback.apply(dr, api);
        }
    }

    private class APIRequestHandlerMapping
    extends RequestMappingHandlerMapping {
        private final LocalWorkspaceURLPathHelper pathHelper = new LocalWorkspaceURLPathHelper();

        private APIRequestHandlerMapping() {
        }

        protected boolean isHandler(Class<?> beanType) {
            return AnnotatedElementUtils.hasAnnotation(beanType, APIService.class);
        }

        public UrlPathHelper getUrlPathHelper() {
            return this.pathHelper;
        }

        public boolean useTrailingSlashMatch() {
            if (APIDispatcher.this.geoServer != null && APIDispatcher.this.geoServer.getGlobal() != null) {
                return APIDispatcher.this.geoServer.getGlobal().isTrailingSlashMatch();
            }
            return true;
        }
    }
}

