/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.geoserver.ogcapi.SortByConverter;
import org.geotools.api.filter.sort.SortBy;

public class APISearchQuery {
    private BigInteger limit;
    private BigInteger startIndex;
    private String crs;
    private String bbox;
    @JsonProperty(value="bbox-crs")
    private String bboxCRS;
    private String datetime;
    private List<String> ids;
    @JsonProperty(value="sortby")
    protected SortBy[] sortBy;
    private String filter;
    @JsonProperty(value="filter-crs")
    private String filterCRS;
    @JsonProperty(value="filter-lang")
    private String filterLang;

    public BigInteger getLimit() {
        return this.limit;
    }

    public void setLimit(BigInteger limit) {
        this.limit = limit;
    }

    public BigInteger getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(BigInteger startIndex) {
        this.startIndex = startIndex;
    }

    public String getCrs() {
        return this.crs;
    }

    public void setCrs(String crs) {
        this.crs = crs;
    }

    public String getBbox() {
        return this.bbox;
    }

    public void setBbox(JsonNode node) {
        this.bbox = node instanceof ArrayNode ? this.arrayNodeToString((ArrayNode)node) : node.textValue();
    }

    public String getDatetime() {
        return this.datetime;
    }

    public void setDatetime(String datetime) {
        this.datetime = datetime;
    }

    public String getBboxCRS() {
        return this.bboxCRS;
    }

    public void setBboxCRS(String bboxCRS) {
        this.bboxCRS = bboxCRS;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public void setIds(JsonNode node) {
        if (node instanceof ArrayNode) {
            this.ids = this.arrayNodeToStringList((ArrayNode)node);
            return;
        }
        String value = node.textValue();
        if (value == null) {
            return;
        }
        this.ids = ImmutableList.copyOf((Object[])value.split(","));
    }

    public SortBy[] getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(JsonNode node) {
        if (node instanceof ArrayNode) {
            List<String> sortBy = this.arrayNodeToStringList((ArrayNode)node);
            this.sortBy = SortByConverter.convertList(sortBy);
            return;
        }
        this.sortBy = SortByConverter.convertString(node.textValue());
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(JsonNode node) {
        if (node instanceof ObjectNode) {
            this.filter = node.toString();
            return;
        }
        this.filter = node.textValue();
    }

    public String getFilterLang() {
        return this.filterLang;
    }

    public void setFilterLang(String filterLang) {
        this.filterLang = filterLang;
    }

    public String getFilterCRS() {
        return this.filterCRS;
    }

    public void setFilterCRS(String filterCRS) {
        this.filterCRS = filterCRS;
    }

    protected List<String> arrayNodeToStringList(ArrayNode node) {
        ArrayList<String> values = new ArrayList<String>(node.size());
        node.forEach(childNode -> {
            if (childNode.isTextual()) {
                values.add(childNode.textValue());
            } else {
                values.add(childNode.toString());
            }
        });
        return values;
    }

    private String arrayNodeToString(ArrayNode node) {
        return this.arrayNodeToStringList(node).stream().collect(Collectors.joining(","));
    }
}

