/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.config.GeoServer;
import org.geoserver.ogcapi.APIException;
import org.geoserver.ogcapi.APIExceptionHandler;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.DefaultAPIExceptionHandler;
import org.geoserver.ows.util.OwsUtils;
import org.geoserver.platform.OWS20Exception;
import org.geoserver.platform.ServiceException;
import org.geotools.util.logging.Logging;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;

public abstract class AbstractAPIExceptionHandler
implements APIExceptionHandler {
    protected static final Logger LOGGER = Logging.getLogger(DefaultAPIExceptionHandler.class);
    protected GeoServer geoServer;

    public AbstractAPIExceptionHandler(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    @Override
    public boolean canHandle(Throwable t, APIRequestInfo request) {
        return true;
    }

    @Override
    public void handle(Throwable t, HttpServletResponse response) {
        response.setContentType("application/json");
        String type = null;
        boolean statusSet = false;
        Object title = null;
        if (t instanceof OWS20Exception) {
            OWS20Exception ex = (OWS20Exception)t;
            if (ex.getHttpCode() != null) {
                response.setStatus(ex.getHttpCode().intValue());
                statusSet = true;
            }
        } else if (t instanceof OWS20Exception) {
            OWS20Exception t2 = (OWS20Exception)t;
            response.setStatus(t2.getHttpCode().intValue());
            type = t2.getCode();
            statusSet = true;
        } else if (t instanceof ServiceException) {
            type = ((ServiceException)t).getCode();
            OWS20Exception.OWSExceptionCode o20Code = OWS20Exception.OWSExceptionCode.getByCode((String)type);
            if (o20Code != null) {
                response.setStatus(o20Code.getHttpCode().intValue());
                statusSet = true;
            }
        } else if (t instanceof APIException) {
            APIException ae = (APIException)t;
            response.setStatus(ae.getStatus().value());
            statusSet = true;
            type = ae.getCode();
        } else if (t instanceof MethodArgumentTypeMismatchException) {
            response.setStatus(400);
            statusSet = true;
            type = "InvalidParameterValue";
            title = "Invalid syntax " + ((MethodArgumentTypeMismatchException)t).getValue() + " for parameter " + ((MethodArgumentTypeMismatchException)t).getParameter().getParameterName();
        }
        if (!statusSet) {
            response.setStatus(500);
        }
        if (type == null) {
            type = "NoApplicableCode";
        }
        if (title == null) {
            title = this.getDescription(t);
        }
        this.writeResponse(response, t, type, (String)title);
    }

    protected abstract void writeResponse(HttpServletResponse var1, Throwable var2, String var3, String var4);

    protected String getDescription(Throwable t) {
        StringBuffer sb = new StringBuffer();
        OwsUtils.dumpExceptionMessages((Throwable)t, (StringBuffer)sb, (boolean)false);
        return sb.toString();
    }

    protected String getStackTrace(Throwable t) {
        String details = null;
        if (this.geoServer.getSettings().isVerboseExceptions()) {
            ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(stackTrace));
            details = new String(stackTrace.toByteArray());
        }
        return details;
    }
}

