/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Optional;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.APIService;
import org.geoserver.ogcapi.AbstractHTMLMessageConverter;
import org.geoserver.ogcapi.FreemarkerTemplateSupport;
import org.geoserver.ogcapi.HTMLResponseBody;
import org.geoserver.platform.ExtensionPriority;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.method.HandlerMethod;

@Component
public class AnnotatedHTMLMessageConverter<T>
extends AbstractHTMLMessageConverter<T>
implements ExtensionPriority {
    private static final String ANNOTATION = "annotation";
    private static final String BASE_CLASS = "baseClass";
    private static final String SERVICE_INFO_CLASS = "serviceInfoClass";

    public AnnotatedHTMLMessageConverter(FreemarkerTemplateSupport support, GeoServer geoServer) {
        super(support, geoServer);
    }

    public static void processAnnotation(HandlerMethod handler) {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        HTMLResponseBody htmlResponseBody = handler.getMethod().getAnnotation(HTMLResponseBody.class);
        if (attributes != null && htmlResponseBody != null) {
            attributes.setAttribute(ANNOTATION, (Object)htmlResponseBody, 0);
            Class<?> baseClass = htmlResponseBody.baseClass();
            if (baseClass == Object.class) {
                baseClass = handler.getBean().getClass();
            }
            attributes.setAttribute(BASE_CLASS, baseClass, 0);
            APIService apiService = APIDispatcher.getApiServiceAnnotation(handler.getBean().getClass());
            if (apiService != null) {
                attributes.setAttribute(SERVICE_INFO_CLASS, apiService.serviceClass(), 0);
            }
        }
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return AnnotatedHTMLMessageConverter.getOptionalRequestAttribute(ANNOTATION, HTMLResponseBody.class).isPresent() && super.canWrite(clazz, mediaType);
    }

    private static <T> T getRequestAttribute(String name, Class<T> type) {
        return AnnotatedHTMLMessageConverter.getOptionalRequestAttribute(name, type).orElseThrow();
    }

    private static <T> Optional<T> getOptionalRequestAttribute(String name, Class<T> type) {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).map(a -> a.getAttribute(name, 0)).filter(type::isInstance).map(type::cast);
    }

    @Override
    protected Class<? extends ServiceInfo> getServiceConfigurationClass() {
        return AnnotatedHTMLMessageConverter.getRequestAttribute(SERVICE_INFO_CLASS, Class.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInternal(T value, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        try {
            HashMap<String, Object> model = this.setupModel(value);
            Charset defaultCharset = this.getDefaultCharset();
            if (outputMessage != null && outputMessage.getBody() != null && defaultCharset != null) {
                this.templateSupport.processTemplate(null, AnnotatedHTMLMessageConverter.getRequestAttribute(ANNOTATION, HTMLResponseBody.class).templateName(), AnnotatedHTMLMessageConverter.getRequestAttribute(BASE_CLASS, Class.class), model, new OutputStreamWriter(outputMessage.getBody(), defaultCharset), defaultCharset);
            } else {
                LOGGER.warning("Either the default character set, output message or body was null, so the template could not be processed.");
            }
        }
        finally {
            this.purgeIterators();
        }
    }

    public int getPriority() {
        return 200;
    }
}

