/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import javax.servlet.http.HttpServletRequest;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.LocalPublished;
import org.geoserver.ows.LocalWorkspace;
import org.springframework.web.util.UrlPathHelper;

public class LocalWorkspaceURLPathHelper
extends UrlPathHelper {
    public LocalWorkspaceURLPathHelper() {
        this.setAlwaysUseFullPath(true);
    }

    public String getRequestUri(HttpServletRequest request) {
        Object uri = super.getRequestUri(request);
        WorkspaceInfo ws = LocalWorkspace.get();
        PublishedInfo published = LocalPublished.get();
        if (ws == null && published == null) {
            return uri;
        }
        String localRequestPrefix = ws == null ? request.getContextPath() + "/" + published.getName() : (published == null ? request.getContextPath() + "/" + ws.getName() : request.getContextPath() + "/" + ws.getName() + "/" + published.getName());
        if (((String)uri).startsWith(localRequestPrefix)) {
            uri = request.getContextPath() + ((String)uri).substring(localRequestPrefix.length());
        }
        return uri;
    }

    public String toLocalPath(String path) {
        WorkspaceInfo ws = LocalWorkspace.get();
        if (ws == null) {
            return path;
        }
        if (path.startsWith("/" + ws.getName())) {
            path = path.substring(ws.getName().length() + 1);
        }
        return path;
    }

    public String getPathWithinApplication(HttpServletRequest request) {
        String path = super.getPathWithinApplication(request);
        return this.toLocalPath(path);
    }
}

