/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.swagger.v3.oas.models.media.Schema;
import java.util.List;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.Link;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Sortables
extends Schema<Object> {
    public static final String REL = "http://www.opengis.net/def/rel/ogc/1.0/sortables";
    private final String schema = "https://json-schema.org/draft/2019-09/schema";
    private String id;
    private String collectionId;
    private AbstractDocument linksHolder = new AbstractDocument();

    public Sortables(String id) {
        this.id = id;
    }

    @JsonProperty(value="$schema")
    public String getSchema() {
        return "https://json-schema.org/draft/2019-09/schema";
    }

    @JsonProperty(value="$id")
    public String getId() {
        return this.id;
    }

    @JsonIgnore
    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    public void addLink(Link link) {
        this.linksHolder.addLink(link);
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JacksonXmlElementWrapper(useWrapping=false)
    @JacksonXmlProperty(namespace="http://www.w3.org/2005/Atom", localName="link")
    public List<Link> getLinks() {
        return this.linksHolder.getLinks();
    }

    public String getLinkUrl(String classification, String type) {
        return this.linksHolder.getLinkUrl(classification, type);
    }

    public List<Link> getLinksFor(String classification) {
        return this.linksHolder.getLinksFor(classification);
    }

    public List<Link> getLinksExcept(String classification, String excludedType) {
        return this.linksHolder.getLinksExcept(classification, excludedType);
    }

    public void addSelfLinks(String path) {
        this.linksHolder.addSelfLinks(path);
    }
}

