/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import org.geoserver.ogcapi.APIBBoxParser;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class APIBBoxParserTest {
    private static final double EPS = 1.0;
    public static final String BBOX_3D_SPEC = "10,20,5,30,40,15";
    public static final String BBOX_2D_SPEC = "10,20,30,40";
    private static PropertyName DEFAULT_GEOMETRY = CommonFactoryFinder.getFilterFactory().property("");

    @Test
    public void testParse2DBBox() throws FactoryException {
        ReferencedEnvelope[] result = APIBBoxParser.parse((String)BBOX_2D_SPEC);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.length);
        ReferencedEnvelope envelope = result[0];
        APIBBoxParserTest.assertEnvelope(envelope, 10.0, 20.0, 30.0, 40.0);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)envelope.getCoordinateReferenceSystem());
    }

    @Test
    public void testToFilter2DBBox() throws FactoryException {
        Filter boxFilter = APIBBoxParser.toFilter((String)BBOX_2D_SPEC);
        Assert.assertNotNull((Object)boxFilter);
        MatcherAssert.assertThat((Object)boxFilter, (Matcher)Matchers.instanceOf(BBOX.class));
        BBOX bboxFilter = (BBOX)boxFilter;
        this.assertEnvelope(bboxFilter.getBounds(), 10.0, 20.0, 30.0, 40.0);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)bboxFilter.getBounds().getCoordinateReferenceSystem());
        Assert.assertEquals((Object)DEFAULT_GEOMETRY, (Object)bboxFilter.getExpression1());
    }

    @Test
    public void testParse3DBBox() throws FactoryException {
        ReferencedEnvelope[] result = APIBBoxParser.parse((String)BBOX_3D_SPEC);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.length);
        ReferencedEnvelope envelope = result[0];
        APIBBoxParserTest.assertEnvelope(envelope, 10.0, 20.0, 5.0, 30.0, 40.0, 15.0);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84_3D, (Object)envelope.getCoordinateReferenceSystem());
    }

    @Test
    public void testToFilter3DBBox() throws FactoryException {
        Filter boxFilter = APIBBoxParser.toFilter((String)BBOX_3D_SPEC);
        Assert.assertNotNull((Object)boxFilter);
        MatcherAssert.assertThat((Object)boxFilter, (Matcher)Matchers.instanceOf(BBOX.class));
        BBOX bboxFilter = (BBOX)boxFilter;
        this.assertEnvelope(bboxFilter.getBounds(), 10.0, 20.0, 5.0, 30.0, 40.0, 15.0);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84_3D, (Object)bboxFilter.getBounds().getCoordinateReferenceSystem());
        Assert.assertEquals((Object)DEFAULT_GEOMETRY, (Object)bboxFilter.getExpression1());
    }

    @Test
    public void testParse2DBBoxWithCRS() throws FactoryException {
        String bbox = BBOX_2D_SPEC;
        String crs = "EPSG:4326";
        ReferencedEnvelope[] result = APIBBoxParser.parse((String)bbox, (String)crs);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.length);
        ReferencedEnvelope envelope = result[0];
        APIBBoxParserTest.assertEnvelope(envelope, 10.0, 20.0, 30.0, 40.0);
        Assert.assertNotNull((Object)envelope.getCoordinateReferenceSystem());
        Assert.assertEquals((Object)crs, (Object)CRS.lookupIdentifier((IdentifiedObject)envelope.getCoordinateReferenceSystem(), (boolean)false));
    }

    @Test
    public void testParseDatelineSpan() throws FactoryException {
        ReferencedEnvelope[] result = APIBBoxParser.parse((String)"160, 20, -160, 40");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.length);
        APIBBoxParserTest.assertEnvelope(result[0], 160.0, 20.0, 180.0, 40.0);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)result[0].getCoordinateReferenceSystem());
        APIBBoxParserTest.assertEnvelope(result[1], -180.0, 20.0, -160.0, 40.0);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)result[1].getCoordinateReferenceSystem());
    }

    @Test
    public void testFilterDatelineSpan() throws FactoryException {
        Filter filter = APIBBoxParser.toFilter((String)"160, 20, -160, 40");
        MatcherAssert.assertThat((Object)filter, (Matcher)Matchers.instanceOf(Or.class));
        Or or = (Or)filter;
        MatcherAssert.assertThat((Object)((Filter)or.getChildren().get(0)), (Matcher)Matchers.instanceOf(BBOX.class));
        MatcherAssert.assertThat((Object)((Filter)or.getChildren().get(1)), (Matcher)Matchers.instanceOf(BBOX.class));
        BBOX bbox1 = (BBOX)or.getChildren().get(0);
        this.assertEnvelope(bbox1.getBounds(), 160.0, 20.0, 180.0, 40.0);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)bbox1.getBounds().getCoordinateReferenceSystem());
        Assert.assertEquals((Object)DEFAULT_GEOMETRY, (Object)bbox1.getExpression1());
        BBOX bbox2 = (BBOX)or.getChildren().get(1);
        this.assertEnvelope(bbox2.getBounds(), -180.0, 20.0, -160.0, 40.0);
        Assert.assertEquals((Object)DefaultGeographicCRS.WGS84, (Object)bbox2.getBounds().getCoordinateReferenceSystem());
        Assert.assertEquals((Object)DEFAULT_GEOMETRY, (Object)bbox2.getExpression1());
    }

    @Test
    public void testToGeometryDatelineSpan() throws FactoryException {
        Geometry geometry = APIBBoxParser.toGeometry((String)"160, 20, -160, 40");
        MatcherAssert.assertThat((Object)geometry, (Matcher)Matchers.instanceOf(MultiPolygon.class));
        Polygon p1 = (Polygon)geometry.getGeometryN(0);
        Assert.assertTrue((boolean)p1.isRectangle());
        Assert.assertEquals((Object)new Envelope(160.0, 180.0, 20.0, 40.0), (Object)p1.getEnvelopeInternal());
        Polygon p2 = (Polygon)geometry.getGeometryN(1);
        Assert.assertTrue((boolean)p2.isRectangle());
        Assert.assertEquals((Object)new Envelope(-180.0, -160.0, 20.0, 40.0), (Object)p2.getEnvelopeInternal());
    }

    @Test
    public void testParse3DBBoxWithCRS() throws FactoryException {
        String bbox = BBOX_3D_SPEC;
        String crs = "EPSG:4326";
        ReferencedEnvelope[] result = APIBBoxParser.parse((String)bbox, (String)crs);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.length);
        ReferencedEnvelope envelope = result[0];
        APIBBoxParserTest.assertEnvelope(envelope, 10.0, 20.0, 5.0, 30.0, 40.0, 15.0);
        Assert.assertNotNull((Object)envelope.getCoordinateReferenceSystem());
        Assert.assertEquals((Object)crs, (Object)CRS.lookupIdentifier((IdentifiedObject)envelope.getCoordinateReferenceSystem(), (boolean)false));
    }

    private void assertEnvelope(BoundingBox bounds, double ... expected) {
        APIBBoxParserTest.assertEnvelope(ReferencedEnvelope.reference((Bounds)bounds), expected);
    }

    private static void assertEnvelope(ReferencedEnvelope envelope, double ... expected) {
        if (expected.length == 6) {
            ReferencedEnvelope3D envelope3D = (ReferencedEnvelope3D)envelope;
            Assert.assertEquals((double)expected[0], (double)envelope3D.getMinX(), (double)1.0);
            Assert.assertEquals((double)expected[1], (double)envelope3D.getMinY(), (double)1.0);
            Assert.assertEquals((double)expected[2], (double)envelope3D.getMinZ(), (double)1.0);
            Assert.assertEquals((double)expected[3], (double)envelope3D.getMaxX(), (double)1.0);
            Assert.assertEquals((double)expected[4], (double)envelope3D.getMaxY(), (double)1.0);
            Assert.assertEquals((double)expected[5], (double)envelope3D.getMaxZ(), (double)1.0);
        } else {
            Assert.assertEquals((double)expected[0], (double)envelope.getMinX(), (double)1.0);
            Assert.assertEquals((double)expected[1], (double)envelope.getMinY(), (double)1.0);
            Assert.assertEquals((double)expected[2], (double)envelope.getMaxX(), (double)1.0);
            Assert.assertEquals((double)expected[3], (double)envelope.getMaxY(), (double)1.0);
        }
    }
}

