/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.sf.json.JSONObject;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.APIRequestInfo;
import org.geoserver.ogcapi.HelloService;
import org.geoserver.ogcapi.Link;
import org.geoserver.ogcapi.MappingJackson2YAMLMessageConverter;
import org.geoserver.ogcapi.Message;
import org.geoserver.ows.Request;
import org.geoserver.ows.TestDispatcherCallback;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.http.MediaType;

public class APIRequestInfoTest
extends GeoServerSystemTestSupport {
    @Before
    public void cleanupCallbacks() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        dispatcher.callbacks.removeIf(c -> c instanceof TestDispatcherCallback);
    }

    @Test
    public void testProducibleMediaTypes() throws Exception {
        this.testDuringOperationExecuted(ri -> {
            Collection mediaTypes = ri.getProducibleMediaTypes(Message.class, true);
            MatcherAssert.assertThat((Object)mediaTypes, (Matcher)Matchers.hasItems((Object[])new MediaType[]{MediaType.APPLICATION_JSON, MappingJackson2YAMLMessageConverter.APPLICATION_YAML}));
        });
    }

    @Test
    public void testLandingPage() throws Exception {
        this.testDuringOperationExecuted(ri -> Assert.assertEquals((Object)"ogc/hello/v1", (Object)ri.getServiceLandingPage()));
    }

    @Test
    public void testLandingPageContext() throws Exception {
        this.testDuringOperationExecuted("ogc/hello/v1", ri -> {
            Assert.assertEquals((Object)"ogc/hello/v1", (Object)ri.getServiceLandingPage());
            Assert.assertEquals((Object)"/geoserver/ogc/hello/v1", (Object)ri.getRequest().getRequestURI());
        });
    }

    @Test
    public void testLandingPageContextWorkspace() throws Exception {
        this.testDuringOperationExecuted("cite/ogc/hello/v1", ri -> Assert.assertEquals((Object)"http://localhost:8080/geoserver/cite/ogc/hello/v1", (Object)ri.getRequest().getRequestURL().toString()));
    }

    @Test
    public void testLandingPageContextWorkspaceLayer() throws Exception {
        this.testDuringOperationExecuted("cite/Buildings/ogc/hello/v1", ri -> Assert.assertEquals((Object)"http://localhost:8080/geoserver/cite/Buildings/ogc/hello/v1", (Object)ri.getRequest().getRequestURL().toString()));
    }

    @Test
    public void testService() throws Exception {
        this.testDuringOperationExecuted(ri -> {
            Service service = ri.getService();
            Assert.assertEquals((Object)"Hello", (Object)service.getId());
            MatcherAssert.assertThat((Object)service.getService(), (Matcher)Matchers.instanceOf(HelloService.class));
        });
    }

    @Test
    public void testIsFormatRequested() throws Exception {
        this.testDuringOperationExecuted(ri -> Assert.assertTrue((boolean)ri.isFormatRequested(MediaType.APPLICATION_JSON, MediaType.APPLICATION_JSON)));
    }

    @Test
    public void testQueryMap() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        dispatcher.callbacks.add(new TestDispatcherCallback(){

            public Object operationExecuted(Request request, Operation operation, Object result) {
                APIRequestInfo ri = APIRequestInfo.get();
                MatcherAssert.assertThat((Object)ri.getSimpleQueryMap(), (Matcher)Matchers.hasEntry((Object)"k1", (Object)"v1"));
                MatcherAssert.assertThat((Object)ri.getSimpleQueryMap(), (Matcher)Matchers.hasEntry((Object)"k2", (Object)"v2"));
                return null;
            }
        });
        JSONObject json = (JSONObject)this.getAsJSON("ogc/hello/v1?k1=v1&k2=v2");
        Assert.assertEquals((Object)"Landing page", (Object)json.get("message"));
    }

    @Test
    public void getLinks() throws Exception {
        this.testDuringOperationExecuted(ri -> {
            List links = ri.getLinksFor("ogc/hello/v1/echo", Message.class, "Message as ", "alternate", true, "test", null);
            Assert.assertEquals((long)4L, (long)links.size());
            HashSet<String> mimeTypes = new HashSet<String>();
            for (Link link : links) {
                Assert.assertEquals((Object)"alternate", (Object)link.getRel());
                Assert.assertEquals((Object)"test", (Object)link.getClassification());
                Assert.assertEquals((Object)("Message as " + link.getType()), (Object)link.getTitle());
                mimeTypes.add(link.getType());
            }
            MatcherAssert.assertThat(mimeTypes, (Matcher)Matchers.hasItems((Object[])new String[]{"application/json", "text/html", "text/plain", "application/yaml"}));
        });
    }

    private APIDispatcher getAPIDispatcher() {
        return (APIDispatcher)applicationContext.getBean(APIDispatcher.class);
    }

    private void testDuringOperationExecuted(Consumer<APIRequestInfo> consumer) throws Exception {
        this.testDuringOperationExecuted("ogc/hello/v1/", consumer);
    }

    private void testDuringOperationExecuted(String path, final Consumer<APIRequestInfo> consumer) throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        dispatcher.callbacks.add(new TestDispatcherCallback(){

            public Object operationExecuted(Request request, Operation operation, Object result) {
                APIRequestInfo ri = APIRequestInfo.get();
                consumer.accept(ri);
                return null;
            }
        });
        JSONObject json = (JSONObject)this.getAsJSON(path);
        if (!"Landing page".equals(json.get("message"))) {
            if ("NoApplicableCode".equals(json.get("type")) && json.has("title")) {
                Assert.fail((String)(path + " failure: " + json.getString("title")));
            } else {
                Assert.fail((String)(path + " failure: " + json.toString()));
            }
        }
    }
}

