/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ogcapi.AbstractDocument;
import org.geoserver.ogcapi.HelloService;
import org.geoserver.ogcapi.MappingJackson2HttpMessageConverter;
import org.geoserver.ogcapi.Message;
import org.geoserver.ogcapi.OGCApiTestSupport;
import org.geoserver.rest.catalog.WorkspaceController;
import org.geoserver.rest.converters.FreemarkerHTMLMessageConverter;
import org.geoserver.rest.converters.XStreamCatalogListConverter;
import org.geoserver.rest.converters.XStreamJSONMessageConverter;
import org.geoserver.rest.converters.XStreamXMLMessageConverter;
import org.geoserver.rest.resources.ResourceDirectoryInfoJSONConverter;
import org.geoserver.rest.wrapper.RestListWrapper;
import org.geoserver.rest.wrapper.RestWrapper;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.http.MediaType;
import org.springframework.http.converter.GenericHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class ApiConfigurationSupportTest
extends OGCApiTestSupport {
    @Test
    public void testUrlHelperType() {
        RequestMappingHandlerMapping mappingHandler = (RequestMappingHandlerMapping)applicationContext.getBean(RequestMappingHandlerMapping.class);
        Assert.assertEquals((Object)mappingHandler.getUrlPathHelper().getClass().getSimpleName(), (Object)"GeoServerUrlPathHelper");
    }

    @Test
    public void testConvertersContainsFreeMarker() {
        RequestMappingHandlerAdapter mappingHandlerAdapter = (RequestMappingHandlerAdapter)applicationContext.getBean(RequestMappingHandlerAdapter.class);
        Assert.assertNotEquals((long)0L, (long)mappingHandlerAdapter.getMessageConverters().stream().filter(c -> c instanceof FreemarkerHTMLMessageConverter).count());
    }

    @Test
    public void testXMLRestConverters() {
        Assert.assertEquals(Arrays.asList(XStreamXMLMessageConverter.class), this.getReadingConverters(RestWrapper.class, MediaType.APPLICATION_XML));
        Assert.assertEquals(Arrays.asList(XStreamXMLMessageConverter.class), this.getWritingConverters(RestWrapper.class, MediaType.APPLICATION_XML));
        Assert.assertEquals(Arrays.asList(XStreamCatalogListConverter.XMLXStreamListConverter.class), this.getWritingConverters(RestListWrapper.class, MediaType.APPLICATION_XML));
    }

    @Test
    public void testJSONRestConverters() {
        Assert.assertEquals(Arrays.asList(XStreamJSONMessageConverter.class), this.getReadingConverters(RestWrapper.class, MediaType.APPLICATION_JSON));
        Assert.assertEquals(Arrays.asList(XStreamJSONMessageConverter.class), this.getWritingConverters(RestWrapper.class, MediaType.APPLICATION_JSON));
        Assert.assertEquals(Arrays.asList(XStreamCatalogListConverter.JSONXStreamListConverter.class), this.getWritingConverters(RestListWrapper.class, MediaType.APPLICATION_JSON));
    }

    @Test
    public void testJSONDocumentConverters() {
        Assert.assertEquals(Arrays.asList(MappingJackson2HttpMessageConverter.class), this.getReadingConverters(AbstractDocument.class, MediaType.APPLICATION_JSON));
        Assert.assertEquals(Arrays.asList(MappingJackson2HttpMessageConverter.class), this.getWritingConverters(AbstractDocument.class, MediaType.APPLICATION_JSON));
    }

    @Test
    public void testReadWithControllerContext() {
        List<Class<?>> workspaceConverters = ApiConfigurationSupportTest.getFilteredConverters(c -> {
            if (c instanceof GenericHttpMessageConverter) {
                return ((GenericHttpMessageConverter)c).canRead(WorkspaceInfo.class, WorkspaceController.class, MediaType.APPLICATION_JSON);
            }
            return c.canRead(WorkspaceInfo.class, MediaType.APPLICATION_JSON);
        });
        Assert.assertEquals(Arrays.asList(XStreamJSONMessageConverter.class), workspaceConverters);
        List<Class<?>> messageConverters = ApiConfigurationSupportTest.getFilteredConverters(c -> {
            if (c instanceof GenericHttpMessageConverter) {
                return ((GenericHttpMessageConverter)c).canRead(Message.class, HelloService.class, MediaType.APPLICATION_JSON);
            }
            return c.canRead(Message.class, MediaType.APPLICATION_JSON);
        });
        Assert.assertEquals(Arrays.asList(MappingJackson2HttpMessageConverter.class), messageConverters);
    }

    private List<Class<?>> getReadingConverters(Class<?> target, MediaType mediaType) {
        return ApiConfigurationSupportTest.getFilteredConverters(c -> c.canRead(target, mediaType) && !(c instanceof ResourceDirectoryInfoJSONConverter));
    }

    private List<Class<?>> getWritingConverters(Class<?> target, MediaType mediaType) {
        return ApiConfigurationSupportTest.getFilteredConverters(c -> c.canWrite(target, mediaType) && !(c instanceof ResourceDirectoryInfoJSONConverter));
    }

    private static List<Class<?>> getFilteredConverters(Predicate<HttpMessageConverter<?>> filter) {
        RequestMappingHandlerAdapter mappingHandlerAdapter = (RequestMappingHandlerAdapter)applicationContext.getBean(RequestMappingHandlerAdapter.class);
        return mappingHandlerAdapter.getMessageConverters().stream().filter(filter).map(c -> c.getClass()).collect(Collectors.toList());
    }
}

