/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.geoserver.ogcapi.DateTimeConverter;
import org.geoserver.ogcapi.DateTimeList;
import org.geotools.util.DateRange;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class DateTimeConverterTest {
    private DateTimeConverter dateTimeConverter;
    private SimpleDateFormat dateFormat;

    @Before
    public void setUp() {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        this.dateTimeConverter = new DateTimeConverter();
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Test
    public void testSingleDate() throws ParseException {
        String input = "2023-10-01T12:00:00.000Z";
        Date expected = this.dateFormat.parse("2023-10-01T12:00:00.000Z");
        DateTimeList result = this.dateTimeConverter.convert(input);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof Date));
        Assert.assertEquals((Object)expected, (Object)result.get(0));
    }

    @Test
    public void testIntervalClosed() throws ParseException {
        String input = "2023-10-01T12:00:00.000Z/2023-10-01T14:00:00.000Z";
        Date start = this.dateFormat.parse("2023-10-01T12:00:00.000Z");
        Date end = this.dateFormat.parse("2023-10-01T14:00:00.000Z");
        DateTimeList result = this.dateTimeConverter.convert(input);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof DateRange));
        DateRange range = (DateRange)result.get(0);
        Assert.assertEquals((Object)start, (Object)range.getMinValue());
        Assert.assertEquals((Object)end, (Object)range.getMaxValue());
    }

    @Test
    @Ignore
    public void testIntervalOpenStart() throws ParseException {
        String input = "../2023-10-01T14:00:00.000Z";
        Date end = this.dateFormat.parse("2023-10-01T14:00:00.000Z");
        DateTimeList result = this.dateTimeConverter.convert(input);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof DateRange));
        DateRange range = (DateRange)result.get(0);
        Assert.assertNull((Object)range.getMinValue());
        Assert.assertEquals((Object)end, (Object)range.getMaxValue());
    }

    @Test
    @Ignore
    public void testIntervalOpenEnd() throws ParseException {
        String input = "2023-10-01T12:00:00.000Z/..";
        Date start = this.dateFormat.parse("2023-10-01T12:00:00.000Z");
        DateTimeList result = this.dateTimeConverter.convert(input);
        Assert.assertEquals((long)1L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof DateRange));
        DateRange range = (DateRange)result.get(0);
        Assert.assertEquals((Object)start, (Object)range.getMinValue().toInstant());
        Assert.assertNull((Object)range.getMaxValue());
    }

    @Test
    public void testSequenceWithSingleTimesAndIntervals() throws ParseException {
        String input = "2023-10-01T11:00:00.000Z,2023-10-01T12:00:00.000Z/2023-10-01T14:00:00.000Z,2023-10-01T15:00:00.000Z";
        Date date1 = this.dateFormat.parse("2023-10-01T11:00:00.000Z");
        Date date2 = this.dateFormat.parse("2023-10-01T12:00:00.000Z");
        Date date3 = this.dateFormat.parse("2023-10-01T14:00:00.000Z");
        Date date4 = this.dateFormat.parse("2023-10-01T15:00:00.000Z");
        DateTimeList result = this.dateTimeConverter.convert(input);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertTrue((boolean)(result.get(0) instanceof Date));
        Assert.assertEquals((Object)date1, (Object)result.get(0));
        Assert.assertTrue((boolean)(result.get(1) instanceof DateRange));
        DateRange range = (DateRange)result.get(1);
        Assert.assertEquals((Object)date2, (Object)range.getMinValue());
        Assert.assertEquals((Object)date3, (Object)range.getMaxValue());
        Assert.assertTrue((boolean)(result.get(2) instanceof Date));
        Assert.assertEquals((Object)date4, (Object)result.get(2));
    }
}

