/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ogcapi;

import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.ogcapi.APIDispatcher;
import org.geoserver.ogcapi.HelloService;
import org.geoserver.ows.Request;
import org.geoserver.ows.Response;
import org.geoserver.ows.TestDispatcherCallback;
import org.geoserver.platform.Operation;
import org.geoserver.platform.Service;
import org.geoserver.test.CodeExpectingHttpServletResponse;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.servlet.handler.DispatcherServletWebRequest;

public class HelloServiceTest
extends GeoServerSystemTestSupport {
    @Before
    public void cleanupCallbacks() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        dispatcher.callbacks.removeIf(c -> c instanceof TestDispatcherCallback);
    }

    @Before
    public void cleanupDefaultValue() throws Exception {
        HelloService controller = (HelloService)applicationContext.getBean(HelloService.class);
        controller.defaultValue = "hello";
    }

    @Test
    public void testDefaultFormat() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertEquals((Object)"{\"message\":\"hello\"}", (Object)response.getContentAsString());
    }

    @Test
    public void testQueryParameters() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        MockHttpServletRequest request = this.setupHelloRequest("message", "yo", "f", "json");
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertEquals((Object)"{\"message\":\"yo\"}", (Object)response.getContentAsString());
    }

    @Test
    public void testYAMLFormatQueryParameter() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        MockHttpServletRequest request = this.setupHelloRequest("f", "yaml");
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/yaml", (Object)response.getContentType());
        Assert.assertEquals((Object)"inline; filename=\"Message.yaml\"", (Object)response.getHeader("Content-Disposition"));
        Assert.assertEquals((Object)"message: hello\n", (Object)response.getContentAsString());
    }

    @Test
    public void testYAMLFormatAcceptHeader() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        request.addHeader("Accept", (Object)"application/yaml");
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/yaml", (Object)response.getContentType());
        Assert.assertEquals((Object)"message: hello\n", (Object)response.getContentAsString());
    }

    @Test
    public void testPostRequest() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        String message = "{\"message\":\"Is there anyone here?\"}";
        MockHttpServletRequest request = this.setupEchoRequest(message, "f", "json");
        request.addHeader("Content-Type", (Object)"application/json");
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)201L, (long)response.getStatus());
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertEquals((Object)"Is there anyone here?", (Object)response.getContentAsString());
    }

    @Test
    public void testDeleteRequest() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        MockHttpServletRequest request = this.setupDeleteRequest();
        request.addHeader("Content-Type", (Object)"application/json");
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)204L, (long)response.getStatus());
    }

    @Test
    public void testPutRequest() throws Exception {
        APIDispatcher dispatcher = (APIDispatcher)applicationContext.getBean(APIDispatcher.class);
        HelloService controller = (HelloService)applicationContext.getBean(HelloService.class);
        String newDefault = "ciao";
        MockHttpServletRequest request = this.setupPutRequest(newDefault, new String[0]);
        request.addHeader("Content-Type", (Object)MediaType.TEXT_PLAIN);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)newDefault, (Object)controller.defaultValue);
    }

    @Test
    public void testDispatcherCallback() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        TestDispatcherCallback callback = new TestDispatcherCallback();
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"{\"message\":\"hello\"}", (Object)response.getContentAsString());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback.dispatcherStatus.get());
    }

    @Test
    public void testDispatcherCallbackOperationName() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        final AtomicReference requestReference = new AtomicReference();
        TestDispatcherCallback callback = new TestDispatcherCallback(){

            public Operation operationDispatched(Request request, Operation operation) {
                requestReference.set(request);
                return operation;
            }
        };
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"Hello", (Object)((Request)requestReference.get()).getService());
        Assert.assertEquals((Object)"1.0.1", (Object)((Request)requestReference.get()).getVersion());
        Assert.assertEquals((Object)"sayHello", (Object)((Request)requestReference.get()).getRequest());
    }

    @Test
    public void testDispatcherCallbackFailInit() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback();
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            public Request init(Request request) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.INIT);
                throw new RuntimeException("TestDispatcherCallbackFailInit");
            }
        };
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        this.checkInternalError(response, "{\"type\":\"NoApplicableCode\",\"title\":\"TestDispatcherCallbackFailInit\"}");
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback1.dispatcherStatus.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callbackFail.dispatcherStatus.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback2.dispatcherStatus.get());
    }

    @Test
    public void testDispatcherCallbackFailServiceDispatched() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback();
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            public Service serviceDispatched(Request request, Service service) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.SERVICE_DISPATCHED);
                throw new RuntimeException("TestDispatcherCallbackFailServiceDispatched");
            }
        };
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        this.checkInternalError(response, "{\"type\":\"NoApplicableCode\",\"title\":\"TestDispatcherCallbackFailServiceDispatched\"}");
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback1.dispatcherStatus.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback2.dispatcherStatus.get());
    }

    @Test
    public void testDispatcherCallbackFailOperationDispatched() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback();
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            public Operation operationDispatched(Request request, Operation operation) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.OPERATION_DISPATCHED);
                throw new RuntimeException("TestDispatcherCallbackFailOperationDispatched");
            }
        };
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        this.checkInternalError(response, "{\"type\":\"NoApplicableCode\",\"title\":\"TestDispatcherCallbackFailOperationDispatched\"}");
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback1.dispatcherStatus.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback2.dispatcherStatus.get());
    }

    @Test
    public void testDispatcherCallbackFailOperationExecuted() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback();
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            public Object operationExecuted(Request request, Operation operation, Object result) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.OPERATION_EXECUTED);
                throw new RuntimeException("TestDispatcherCallbackFailOperationExecuted");
            }
        };
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        this.checkInternalError(response, "{\"type\":\"NoApplicableCode\",\"title\":\"TestDispatcherCallbackFailOperationExecuted\"}");
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback1.dispatcherStatus.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback2.dispatcherStatus.get());
    }

    @Test
    public void testDispatcherCallbackFailResponseDispatched() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback();
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            public Response responseDispatched(Request request, Operation operation, Object result, Response response) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.RESPONSE_DISPATCHED);
                throw new RuntimeException("TestDispatcherCallbackFailResponseDispatched");
            }
        };
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        this.checkInternalError(response, "{\"type\":\"NoApplicableCode\",\"title\":\"TestDispatcherCallbackFailResponseDispatched\"}");
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback1.dispatcherStatus.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback2.dispatcherStatus.get());
    }

    @Test
    public void testDispatcherCallbackFailFinished() throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        final AtomicBoolean firedCallback = new AtomicBoolean(false);
        TestDispatcherCallback callback1 = new TestDispatcherCallback();
        TestDispatcherCallback callback2 = new TestDispatcherCallback(){

            public void finished(Request request) {
                firedCallback.set(true);
                super.finished(request);
            }
        };
        TestDispatcherCallback callbackFail = new TestDispatcherCallback(){

            public void finished(Request request) {
                this.dispatcherStatus.set(TestDispatcherCallback.Status.FINISHED);
                throw new Error("TestDispatcherCallbackFailFinished");
            }
        };
        MockHttpServletRequest request = this.setupHelloRequest(new String[0]);
        MockHttpServletResponse response = new MockHttpServletResponse();
        dispatcher.callbacks.add(callback1);
        dispatcher.callbacks.add(callbackFail);
        dispatcher.callbacks.add(callback2);
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertEquals((Object)"{\"message\":\"hello\"}", (Object)response.getContentAsString());
        Assert.assertTrue((boolean)firedCallback.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback1.dispatcherStatus.get());
        Assert.assertEquals((Object)TestDispatcherCallback.Status.FINISHED, callback2.dispatcherStatus.get());
    }

    @Test
    public void testHttpErrorCodeException() throws Exception {
        this.assertHttpErrorCode("noContent", 204);
    }

    @Test
    public void testWrappedHttpErrorCodeException() throws Exception {
        this.assertHttpErrorCode("wrappedException", 204);
    }

    @Test
    public void testBadRequestHttpErrorCodeException() throws Exception {
        this.assertHttpErrorCode("badRequest", 400);
    }

    @Test
    public void testHttpErrorCodeExceptionWithContentType() throws Exception {
        CodeExpectingHttpServletResponse rsp = this.assertHttpErrorCode("errorWithPayload", 200);
        Assert.assertEquals((Object)"application/json", (Object)rsp.getContentType());
    }

    @Test
    public void testDocumentDefaultMime() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/hello/v1/document");
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        JSONObject json = (JSONObject)this.json(response);
        Assert.assertEquals((Object)"hello", (Object)json.get("message"));
        JSONArray links = json.getJSONArray("links");
        Assert.assertEquals((long)3L, (long)links.size());
        for (int i = 0; i < links.size(); ++i) {
            JSONObject link = links.getJSONObject(i);
            if ("self".equals(link.getString("rel"))) {
                Assert.assertEquals((Object)"This document", (Object)link.getString("title"));
                Assert.assertEquals((Object)"application/json", (Object)link.getString("type"));
                Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/hello/v1/document?f=application%2Fjson", (Object)link.getString("href"));
                continue;
            }
            if ("alternate".equals(link.getString("rel")) && "application/yaml".equals(link.getString("type"))) {
                Assert.assertEquals((Object)"This document as application/yaml", (Object)link.getString("title"));
                Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/hello/v1/document?f=application%2Fyaml", (Object)link.getString("href"));
                continue;
            }
            if ("alternate".equals(link.getString("rel"))) {
                Assert.assertEquals((Object)"This document as text/html", (Object)link.getString("title"));
                Assert.assertEquals((Object)"text/html", (Object)link.getString("type"));
                Assert.assertEquals((Object)"http://localhost:8080/geoserver/ogc/hello/v1/document?f=text%2Fhtml", (Object)link.getString("href"));
                continue;
            }
            Assert.fail((String)("Unexpected link: " + link));
        }
    }

    @Test
    public void testDocumentHTML() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/hello/v1/document?f=html");
        Assert.assertEquals((Object)"text/html", (Object)response.getContentType());
        String expected = "<html>\n<head>\n    <script src=\"http://localhost:8080/geoserver/webresources/ogcapi/hello.js\"></script>\n</head>\n<body>\n  <p>The message: hello</p>\n  <p><a class=\"wmsCapabilities\" href=\"http://localhost:8080/geoserver/wms?request=GetCapabilities&amp;service=WMS\">Capabilities URL</a></p>\n</body>\n</html>";
        String normalizedResponse = response.getContentAsString().replaceAll("\r\n", "\n");
        Assert.assertEquals((Object)expected, (Object)normalizedResponse);
    }

    @Test
    public void testHelloPlainText() throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse("ogc/hello/v1/hello?f=text/plain");
        Assert.assertEquals((Object)"text/plain", (Object)response.getContentType());
        Assert.assertEquals((Object)"hello", (Object)response.getContentAsString());
    }

    @Test
    public void testeServiceDisabled() throws Exception {
        HelloService hs = (HelloService)applicationContext.getBean(HelloService.class);
        try {
            hs.getServiceInfo().setEnabled(false);
            MockHttpServletResponse response = this.getAsServletResponse("ogc/hello/v1");
            Assert.assertEquals((long)404L, (long)response.getStatus());
            Assert.assertEquals((Object)"Service Hello is disabled", (Object)response.getErrorMessage());
        }
        finally {
            hs.getServiceInfo().setEnabled(true);
        }
    }

    private CodeExpectingHttpServletResponse assertHttpErrorCode(String path, int expectedCode) throws Exception {
        APIDispatcher dispatcher = this.getAPIDispatcher();
        MockHttpServletRequest request = this.setupRequestBase(new String[0]);
        request.setMethod("GET");
        request.setServletPath("/geoserver/ogc");
        request.setPathInfo("hello/v1/" + path);
        request.setRequestURI("/geoserver/ogc/hello/v1/" + path);
        CodeExpectingHttpServletResponse response = new CodeExpectingHttpServletResponse((HttpServletResponse)new MockHttpServletResponse());
        dispatcher.handleRequest((HttpServletRequest)request, (HttpServletResponse)response);
        Assert.assertEquals((long)expectedCode, (long)response.getStatusCode());
        Assert.assertEquals((Object)(expectedCode >= 400 ? 1 : 0), (Object)response.isError());
        return response;
    }

    private APIDispatcher getAPIDispatcher() {
        return (APIDispatcher)applicationContext.getBean(APIDispatcher.class);
    }

    private MockHttpServletRequest setupDeleteRequest() {
        MockHttpServletRequest request = this.setupRequestBase(new String[0]);
        request.setServletPath("/geoserver/ogc");
        request.setPathInfo("hello/v1/delete");
        request.setRequestURI("/geoserver/ogc/hello/v1/delete");
        request.setMethod("DELETE");
        return request;
    }

    private MockHttpServletRequest setupPutRequest(String message, String ... params) {
        MockHttpServletRequest request = this.setupRequestBase(params);
        request.setServletPath("/geoserver/ogc");
        request.setPathInfo("hello/v1/default");
        request.setMethod("PUT");
        request.setRequestURI("/geoserver/ogc/hello/v1/default");
        request.setContent(message.getBytes(StandardCharsets.UTF_8));
        return request;
    }

    private MockHttpServletRequest setupEchoRequest(String message, String ... params) {
        MockHttpServletRequest request = this.setupRequestBase(params);
        request.setServletPath("/geoserver/ogc");
        request.setPathInfo("hello/v1/hello");
        request.setMethod("POST");
        request.setRequestURI("/geoserver/ogc/hello/v1/echo");
        request.setContent(message.getBytes(StandardCharsets.UTF_8));
        return request;
    }

    private MockHttpServletRequest setupHelloRequest(String ... params) {
        MockHttpServletRequest request = this.setupRequestBase(params);
        request.setServletPath("/geoserver/ogc");
        request.setPathInfo("hello/v1/hello");
        request.setMethod("GET");
        request.setRequestURI("/geoserver/ogc/hello/v1/hello");
        return request;
    }

    private MockHttpServletRequest setupRequestBase(String ... params) {
        MockHttpServletRequest request = new MockHttpServletRequest(){
            String encoding;

            public int getServerPort() {
                return 8080;
            }

            public String getCharacterEncoding() {
                return this.encoding;
            }

            public void setCharacterEncoding(String encoding) {
                this.encoding = encoding;
            }
        };
        request.setScheme("http");
        request.setServerName("localhost");
        request.setContextPath("/geoserver");
        request.setServletPath("/geoserver/ogc");
        if (params != null) {
            Map<String, String> map = HelloServiceTest.toMap(params);
            map.forEach((k, v) -> request.addParameter(k, v));
            request.setQueryString(map.entrySet().stream().map(Object::toString).collect(Collectors.joining("&")));
        }
        RequestContextHolder.setRequestAttributes((RequestAttributes)new DispatcherServletWebRequest((HttpServletRequest)request));
        return request;
    }

    public static Map<String, String> toMap(String ... keyValues) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < keyValues.length; i += 2) {
            map.put(keyValues[i], keyValues[i + 1]);
        }
        return map;
    }

    private void checkInternalError(MockHttpServletResponse response, String s) throws UnsupportedEncodingException {
        Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
        Assert.assertEquals((long)500L, (long)response.getStatus());
        Assert.assertEquals((Object)s, (Object)response.getContentAsString());
    }
}

